package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.EchartVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzspVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzsqVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzspService
 * @author chris
 * @description 服装标志审批服务层接口
 * @version 1.0
 * @date 2021-05-24 15:45
 */
public interface ZbglFzbzspService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglFzbzspVo> pageData(Page<ZbglFzbzspVo> page, ZbglFzbzspVo entity, String belongOrgId);

    /******
     * 分页查询
     * @param entity 实体类
     * @param isFilter 是否过滤
     * @param fzbzhzsbId 服装标志汇总上报id
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZbglFzbzspVo> listDataForReport(ZbglFzbzspVo entity, boolean isFilter, String fzbzhzsbId, String belongOrgId);

    /*******
     * 新增服装标志审批信息
     * @param entity 服装标志申请信息
     * @param curUser 当前登录用户
     */
    void saveZbglFzbzspInfo(ZbglFzbzsqVo entity, SysUser curUser);

    /*******
     * 获取服装标志审批信息
     * @param fzbzspId 服装标志审批Id
     * @return
     */
    ZbglFzbzspVo getEntityInfoById(String fzbzspId);

    /******
     * 审批服装标志申请
     * @param entity 实体类
     * @param curUser 当前登录用户
     */
    void shenPi(ZbglFzbzspVo entity, SysUser curUser);

    /*****
     * 撤销服装标志预审通过记录
     * @param entity
     * @param curUser
     */
    void revoke(ZbglFzbzspVo entity, SysUser curUser);

    /*****
     * 更新数据审批状态
     * @param fzbzsqId 主键Id
     * @param spzt 审批状态
     * @param curUser 当前登录用户
     */
    void updateEntityInfoSpztByFzbzsqId(String fzbzsqId, String spzt, SysUser curUser);

    /*****
     * 申请类型数量查询
     * @param orgId 单位id
     * @return
     */
    List<EchartVo> querySqlxNum(String orgId);

    /*****
     * 保存服装首发登记服装标志审批
     * @param sfdjId 首发登记Id
     * @param detailInfo 首发登记明细信息
     * @param curUser 当前登录用户
     */
    void saveSfdjFzbzspInfo(String sfdjId, String detailInfo, SysUser curUser);
}
