package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzspLsVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzspVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzspLsService
 * @author chris
 * @description 服装标志审批历史服务层接口
 * @version 1.0
 * @date 2021-05-27 10:32
 */
public interface ZbglFzbzspLsService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglFzbzspLsVo> pageData(Page<ZbglFzbzspLsVo> page, ZbglFzbzspLsVo entity, String belongOrgId);

    /******
     * 列表查询
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZbglFzbzspLsVo> listData(ZbglFzbzspLsVo entity, String belongOrgId);

    /*******
     * 新增服装标志审批历史信息
     * @param entity 服装标志审批信息
     * @param curUser 当前登录用户
     */
    void saveZbglFzbzspLsInfo(ZbglFzbzspVo entity, SysUser curUser);

    /*******
     * 新增首发登记服装标志审批信息
     * @param sfdjId 首发登记Id
     * @param detailInfo 首发登记明细信息
     * @param curUser 当前登录用户
     */
    void saveSfdjFzbzspLsInfo(String sfdjId, String detailInfo, SysUser curUser);

    /*****
     * 更新数据审批状态
     * @param fzbzsqId 服装标志申请Id
     * @param spzt 审批状态
     * @param curUser 当前登录用户
     */
    void updateEntityInfoSpztByFzbzsqId(String fzbzsqId, String spzt, SysUser curUser);

    /*******
     * 获取服装标志审批历史信息
     * @param fzbzspLsId 服装标志审批历史Id
     * @return
     */
    ZbglFzbzspLsVo getEntityInfoById(String fzbzspLsId);

    /*******
     * 获取服装标志审批历史总数
     * @param fzbzspId 服装标志审批Id
     * @return
     */
    Integer getEntityInfoCountByFzbzsqId(String fzbzspId);
}
