package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.EchartVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzpfjlVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzpfService
 * @author hufanghua
 * @description 装备配发Service接口层接口
 * @version 1.0
 * @date 2021-05-25 11:14
 */
public interface ZbglFzbzpfjlService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglFzbzpfjlVo> pageData(Page<ZbglFzbzpfjlVo> page, ZbglFzbzpfjlVo entity, String belongOrgId);

    /*****
     * 列表查询
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZbglFzbzpfjlVo> listData(ZbglFzbzpfjlVo entity, String belongOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键Id集合
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZbglFzbzpfjlVo> exportsData(ZbglFzbzpfjlVo entity, String ids, String belongOrgId);

    /*****
     * 装备数量查询
     * @param orgId 机构id
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @return
     */
    List<EchartVo> queryZbslByOrgId(String orgId, String startDate, String endDate);

    /******
     * 保存服装标志配发记录信息
     * @param fzbzpfId 服装配发Id
     * @param detailInfo 配发记录信息
     * @param curUser 当前登录用户
     */
    void saveZbglFzbzpfjlInfo(String fzbzpfId, String detailInfo, SysUser curUser);

    /*****
     * 保存服装首发登记配发记录
     * @param sfdjId 首发登记Id
     * @param fzbzpfId 服装配发Id
     * @param detailInfo 首发登记明细信息
     * @param curUser 当前登录用户
     */
    void saveSfdjFzbzpfjlInfo(String sfdjId, String fzbzpfId, String detailInfo, SysUser curUser);
}
