package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.EchartVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzpfVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzspVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzpfService
 * @author hufanghua
 * @description 装备配发Service接口层接口
 * @version 1.0
 * @date 2021-05-25 11:14
 */
public interface ZbglFzbzpfService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZbglFzbzpfVo> pageData(Page<ZbglFzbzpfVo> page, ZbglFzbzpfVo entity, String belongOrgId);

    /*******
     * 保存配发信息
     * @param fzbzspInfo 服装审批信息
     * @param curUser 当前登录用户
     */
    void saveZbglFzbzpfInfo(ZbglFzbzspVo fzbzspInfo, SysUser curUser);

    /*******
     * 保存配发信息
     * @param sfdjId 首发登记Id
     * @param fzbzspId 服装标志审批Id
     * @param detailInfo 首发登记明细信息
     * @param curUser 当前登录用户
     */
    void saveSfdjFzbzpfInfo(String sfdjId, String fzbzspId, String detailInfo, SysUser curUser);

    /*****
     * 更新数据审批状态
     * @param fzbzsqId 服装标志申请Id
     * @param spzt 审批状态
     * @param curUser 当前登录用户
     */
    void updateEntityInfoSpztByFzbzsqId(String fzbzsqId, String spzt, SysUser curUser);

    /*******
     * 获取服装标志配发信息
     * @param fzbzpfId 服装标志配发Id
     * @return
     */
    ZbglFzbzpfVo getEntityInfoById(String fzbzpfId);

    /******
     * 配发服装标志申请
     * @param entity 实体类
     * @param curUser 当前登录用户
     */
    void peiFa(ZbglFzbzpfVo entity, SysUser curUser);

    /*****
     * 获取各地区配发人数
     * @return
     */
    List<EchartVo> queryRstj();

    /*****
     * 获取各地区换发人次
     * startDate
     * endDate
     * @return
     */
    List<EchartVo> queryHfrcsl(String startDate, String endDate);
}
