package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzhzsbmxVo;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzpfjlVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzhzsbmxService
 * @author chris
 * @description 服装标志汇总上报明细服务层接口
 * @version 1.0
 * @date 2021-05-17 10:45
 */
public interface ZbglFzbzhzsbmxService {

    /*******
     * 保存服装标志上报明细信息
     * @param fzbzhzsbId 服装标志上报Id
     * @param detailInfo 上报明细信息
     * @param curUser 当前登录用户
     */
    void saveFzbzhzsbDetailInfo(String fzbzhzsbId, String detailInfo, SysUser curUser);

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<ZbglFzbzhzsbmxVo> pageData(Page<ZbglFzbzhzsbmxVo> page, ZbglFzbzhzsbmxVo entity);


    /*****
     * 列表查询
     * @param entity 实体类
     * @return
     */
    List<ZbglFzbzhzsbmxVo> listData(ZbglFzbzhzsbmxVo entity);

    /*******
     * 获取服装标志上报明细信息
     * @param fzbzhzsbId 服装标志上报Id
     * @return
     */
    List<ZbglFzbzhzsbmxVo> getEntityListDataByFzbzhzsbId(String fzbzhzsbId);

    /*****
     * 删除服装标志上报明细信息
     * @param fzbzhzsbId 服装标志上报Id
     * @param curUser 当前登录用户
     */
    void deleteDataByFzbzhzsbId(String fzbzhzsbId, SysUser curUser);

    /*****
     * 删除服装标志上报明细信息
     * @param fzbzhzsbId 服装标志上报Id
     */
    void deleteEntityInfoByFzbzhzsbId(String fzbzhzsbId);

    /*****
            * 导出查询
     * @param entity 实体类
     * @param ids 主键Id集合
     * @param belongOrgId 当前登录用户组织机构Id
     * @return
             */
    List<ZbglFzbzhzsbmxVo> exportsData(ZbglFzbzpfjlVo entity, String ids, String belongOrgId);
}
