package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.ZbglFzbzhzsbVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className ZbglFzbzhzsbService
 * @author hufanghua
 * @description 追责登记Service接口层接口
 * @version 1.0
 * @date 2021-04-19 11:14
 */
public interface ZbglFzbzhzsbService {

    /*****
     * 分页查询
     * @param page
     * @param entity
     * @param curUserOrgId
     * @return
     */
    Page<ZbglFzbzhzsbVo> pageData(Page<ZbglFzbzhzsbVo> page, ZbglFzbzhzsbVo entity, String curUserOrgId);

    /*****
     * 列表查询
     * @param entity
     * @param curUserOrgId
     * @return
     */
    List<ZbglFzbzhzsbVo> listData(ZbglFzbzhzsbVo entity, String curUserOrgId);

    /*****
     * 保存或修改
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     * @param isApply 是否上报
     */
    void saveOrUpdate(ZbglFzbzhzsbVo entity, SysUser user, boolean isCreate, boolean isApply);

    /*****
     * 获取数据
     * @param id 主键ID
     * @return
     */
    ZbglFzbzhzsbVo getEntityInfoById(String id);

    /*****
     * 更新数据审批状态
     * @param id 主键Id
     * @param spzt 审批状态
     * @param curUser 当前登录用户
     */
    void updateEntityInfoSpzt(String id, String spzt, SysUser curUser);

    /*****
     * 审批不通过清空绑定的审批信息
     * @param id 主键Id
     * @param curUser 当前登录用户
     */
    void updateEntity(String id, String zt, SysUser curUser);

    /*****
     * @param fzbzhzsbId 服装标志上报Id
     *查询所有保存的审批id
     */
    String queryAllFzbzspId(String fzbzhzsbId);

}
