package com.kdgcsoft.jt.xzzf.dubbo.fzbz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity.GrnddeVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity.ZfryRyxxVo;

import java.util.List;

/****
 * @className GrnddeService
 * @author hufanghua
 * @description 个人年度定额Service接口层接口
 * @version 1.0
 * @date 2021-04-13 11:14
 */
public interface GrnddeService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前用户机构id
     * @return
     */
    Page<GrnddeVo> page(Page<GrnddeVo> page, GrnddeVo entity, String curUserOrgId);

    /*****
     * 保存或修改
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    void saveOrUpdate(GrnddeVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取数据
     * @param id 主键ID
     * @return
     */
    GrnddeVo getEntityInfoById(String id);

    /*****
     * 获取数据
     * @param zfryId 执法人员ID
     * @param nf 年份
     * @return
     */
    GrnddeVo getEntityInfoByZfryId(String zfryId, String nf);

    /*****
     * 删除数据
     * @param ids
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 保存
     * @param entity 实体类
     * @param user 当前登录用户
     */
    void syncSysZfryInfo(ZfryRyxxVo entity, SysUser user);

    /*****
     * 批量修改个人年度定额信息
     * @param details 个人年度定额实体集合
     * @param user
     */
    void updateDataByIds(String details, SysUser user);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<GrnddeVo> export(GrnddeVo entity, String ids, String curUserOrgId);

    /***
     * 计算年度定额
     * @param zfryId 执法人员ID
     * @param nf 年份
     * @return
     */
    int countNdde(String zfryId, String nf);

    /*****
     * 获取最终年度定额
     * @param zfryId 执法人员ID
     * @return
     */
    String queryZzndde(String zfryId);

    /*****
     * 获取最终年度定额
     * @param zfryId 执法人员ID
     * @param sqed 申请额度
     * @param flag 加减标识
     * @param user 操作人
     * @return
     */
    void countZzndde(String zfryId, String sqed, boolean flag, SysUser user);

    //定时任务--生成次年年度定额
    void zffzDqghPfxqmxTask() ;
}
