package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglZbsfdjVo
 * @author chris
 * @description 装备首次发放登记实体类
 * @version 1.0
 * @date 2021-04-17 12:11
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_ZBSFDJMX")
public class ZbglZbsfdjmxVo extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId("ZBSFDJMX_ID")
    @TableField("ZBSFDJMX_ID")
    private String zbsfdjmxId;

    /******
     * 装备首发登记Id
     */
    @TableField("ZBSFDJ_ID")
    private String zbsfdjId;

    /******
     * 装备名称Id
     */
    @TableField("ZBMC_ID")
    private String zbmcId;

    /******
     * 装备名称
     */
    @TableField("ZBMC")
    private String zbmc;

    /******
     * 首次配发数量
     */
    @TableField("SCPFSL")
    private String scpfsl;

    /******
     * 适用气候区代码
     */
    @TableField("SYQHQDM")
    private String syqhqdm;

    /******
     * 计量单位
     */
    @TableField("JLDW")
    private String jldw;

    /******
     * 装备尺寸
     */
    @TableField("ZBCC")
    private String zbcc;

    /******
     * 装备单价(单位:元)
     */
    @TableField("ZBDJ")
    private String zbdj;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用人群代码
     */
    @TableField("SYRQDM")
    private String syrqdm;

    /******
     * 期满换发年限
     */
    @TableField("QMHFNX")
    private String qmhfnx;

    /******
     * 期满换发年份
     */
    @TableField("QMHFNF")
    private String qmhfnf;

    /******
     * 首次配发年份
     */
    @TableField(exist = false)
    private String scpfnf;

    /******
     * 期满换发数量
     */
    @TableField(exist = false)
    private String qmhfsl;

    /******
     * 装备分类状态Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    /******
     * 适用气候区代码Text
     */
    @TableField(exist = false)
    private String syqhqdmText;

    /******
     * 配发类型
     */
    @TableField(exist = false)
    private String pflx;

    /******
     * 配发类型
     */
    @TableField(exist = false)
    private String userId;

    /******
     * 执法人员Id
     */
    @TableField(exist = false)
    private String zfryId;

    /******
     * 装备总价
     */
    @TableField(exist = false)
    private String zbzj;

    /******
     * 配发日期
     */
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date pfrq;

    @Override
    public String getId() {
        return zbsfdjmxId;
    }

    @Override
    public void setId(String id) {
        this.zbsfdjmxId = id;
    }
}
