package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglZbsfdjVo
 * @author chris
 * @description 装备首次发放登记实体类
 * @version 1.0
 * @date 2021-04-17 12:11
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_ZBSFDJ")
public class ZbglZbsfdjVo extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId("ZBSFDJ_ID")
    @TableField("ZBSFDJ_ID")
    private String zbsfdjId;

    /******
     * 订单流水号
     */
    @TableField("ORDER_CODE")
    private String orderCode;

    /******
     * 执法人员Id
     */
    @TableField("ZFRY_ID")
    private String zfryId;

    /******
     * 执法人员所在区划Id
     */
    @TableField("XZQH_ID")
    private String xzqhId;

    /******
     * 所属单位Id
     */
    @TableField("ORG_ID")
    private String orgId;

    /******
     * 登记人Id
     */
    @TableField("DJR_ID")
    private String djrId;

    /******
     * 登记日期
     */
    @TableField("DJRQ")
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date djrq;

    /******
     * 首次配发年份
     */
    @TableField("SCPFNF")
    private String scpfnf;

    /******
     * 登记总额
     */
    @TableField("DJZE")
    private String djze;

    /******
     * 备注
     */
    @TableField("REMARK")
    private String remark;

    /******
     * 所属单位名称
     */
    @TableField(exist = false)
    private String orgName;

    /******
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String zfryXm;

    /*****
     * 身份证件号码
     */
    @TableField(exist = false)
    private String idCard;

    /******
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /******
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /******
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /******
     * 入职日期
     */
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date rzrq;

    /******
     * 登记人名称
     */
    @TableField(exist = false)
    private String djrName;

    /******
     * 装备首发登记明细(前台传到后台)
     */
    @TableField(exist = false)
    private String detailInfo;

    /******
     * 装备单价
     */
    @TableField(exist = false)
    private String zbdj;

    /******
     * 首次配发数量
     */
    @TableField(exist = false)
    private String scpfsl;

    /******
     * 期满换发年限
     */
    @TableField(exist = false)
    private String qmhfnx;

    /******
     * 品类名称id
     */
    @TableField(exist = false)
    private String zbmcId;

    /******
     * 期满换发数量
     */
    @TableField(exist = false)
    private String qmhfsl;

    /******
     * 适用人群代码
     */
    @TableField(exist = false)
    private String syrqdm;

    /******
     * 装备尺寸
     */
    @TableField(exist = false)
    private String zbcc;

    /******
     * 装备名称
     */
    @TableField(exist = false)
    private String zbmc;

    /******
     * 计量单位
     */
    @TableField(exist = false)
    private String jldw;

    /******
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    /******
     * 允许修改
     * 01-允许
     * 02-不允许
     */
    @TableField(exist = false)
    private String allowModify;

    @Override
    public String getId() {
        return zbsfdjId;
    }

    @Override
    public void setId(String id) {
        this.zbsfdjId = id;
    }
}
