package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZbglZbplVo
 * @author chris
 * @description 装备品类实体类
 * @version 1.0
 * @date 2021-04-14 17:54
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_ZBPL")
public class ZbglZbplVo extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId("ZBPL_ID")
    @TableField("ZBPL_ID")
    private String zbplId;

    /******
     * 装备品类名称
     */
    @TableField("ZBPLMC")
    private String zbplmc;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用人群代码
     */
    @TableField("SYRQDM")
    private String syrqdm;

    /******
     * 装备品类状态
     */
    @TableField("ZBPLZT")
    private String zbplzt;

    /******
     * 登记单位Id
     */
    @TableField("ORG_ID")
    private String orgId;

    /******
     * 备注
     */
    @TableField("REMARK")
    private String remark;

    /******
     * 登记单位名称
     */
    @TableField(exist = false)
    private String orgName;

    /******
     * 装备分类代码Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 装备品类状态Text
     */
    @TableField(exist = false)
    private String zbplztText;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    @Override
    public String getId() {
        return zbplId;
    }

    @Override
    public void setId(String id) {
        this.zbplId = id;
    }
}
