package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZbglZbmcVo
 * @author chris
 * @description 装备名称实体类
 * @version 1.0
 * @date 2021-04-14 20:57
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_ZBMC")
public class ZbglZbmcVo extends BaseEntity<String> {

    /******
     * 来源方式:
     * 01-厅级,
     * 02-各个单位
     */
    public static final String ZBMC_SOURCE_TYPE_01 = "01";
    public static final String ZBMC_SOURCE_TYPE_02 = "02";

    /******
     * 主键Id
     */
    @TableId("ZBMC_ID")
    @TableField("ZBMC_ID")
    private String zbmcId;

    /******
     * 装备名称
     */
    @TableField("ZBMC")
    private String zbmc;

    /******
     * 登记单位Id
     */
    @TableField("ORG_ID")
    private String orgId;

    /******
     * 装备品类Id
     */
    @TableField("ZBPL_ID")
    private String zbplId;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用气候区代码
     */
    @TableField("SYQHQDM")
    private String syqhqdm;

    /******
     * 首次配发数量
     */
    @TableField("SCPFSL")
    private String scpfsl;

    /******
     * 期满换发年限
     */
    @TableField("QMHFNX")
    private String qmhfnx;

    /******
     * 期满换发数量
     */
    @TableField("QMHFSL")
    private String qmhfsl;

    /******
     * 计量单位
     */
    @TableField("JLDW")
    private String jldw;

    /******
     * 装备尺寸
     */
    @TableField("ZBCC")
    private String zbcc;

    /******
     * 装备单价(单位:元)
     */
    @TableField("ZBDJ")
    private String zbdj;

    /******
     * 装备数量
     */
    @TableField("ZBSL")
    private String zbsl;

    /******
     * 装备名称状态
     */
    @TableField("ZBMCZT")
    private String zbmczt;

    /******
     * 来源方式:
     * 01-厅级,
     * 02-各个单位
     */
    @TableField("SOURCE_TYPE")
    private String sourceType;

    /******
     * 备注
     */
    @TableField("REMARK")
    private String remark;

    /******
     * 装备分类代码Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 装备名称状态Text
     */
    @TableField(exist = false)
    private String zbmcztText;

    /******
     * 来源方式Text
     */
    @TableField(exist = false)
    private String sourceTypeText;

    /******
     * 适用气候区代码Text
     */
    @TableField(exist = false)
    private String syqhqdmText;

    /******
     * 适用人群代码
     */
    @TableField(exist = false)
    private String syrqdm;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    /******
     * 登记单位名称
     */
    @TableField(exist = false)
    private String orgName;

    /******
     * 装备品类名称
     */
    @TableField(exist = false)
    private String zbplmc;

    @Override
    public String getId() {
        return zbmcId;
    }

    @Override
    public void setId(String id) {
        this.zbmcId = id;
    }
}
