package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZbglFzbzsqmxVo
 * @author chris
 * @description 服装标志申请明细实体类
 * @version 1.0
 * @date 2021-04-25 10:16
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZSQMX")
public class ZbglFzbzsqmxVo extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId("FZBZSQMX_ID")
    @TableField("FZBZSQMX_ID")
    private String fzbzsqmxId;

    /******
     * 服装标志申请Id
     */
    @TableField("FZBZSQ_ID")
    private String fzbzsqId;

    /******
     * 装备名称Id
     */
    @TableField("ZBMC_ID")
    private String zbmcId;

    /******
     * 装备名称
     */
    @TableField("ZBMC")
    private String zbmc;

    /******
     * 申请数量
     */
    @TableField("SQSL")
    private String sqsl;

    /******
     * 适用气候区代码
     */
    @TableField("SYQHQDM")
    private String syqhqdm;

    /******
     * 计量单位
     */
    @TableField("JLDW")
    private String jldw;

    /******
     * 装备尺寸
     */
    @TableField("ZBCC")
    private String zbcc;

    /******
     * 装备单价(单位:元)
     */
    @TableField("ZBDJ")
    private String zbdj;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用人群代码
     */
    @TableField("SYRQDM")
    private String syrqdm;

    /******
     * 期满换发年限
     */
    @TableField("QMHFNX")
    private String qmhfnx;

    /******
     * 期满换发年份
     */
    @TableField("QMHFNF")
    private String qmhfnf;

    /******
     * 首次配发年份
     */
    @TableField(exist = false)
    private String scpfnf;

    /******
     * 期满换发数量
     */
    @TableField(exist = false)
    private String qmhfsl;

    /******
     * 装备分类状态Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    /******
     * 适用气候区代码Text
     */
    @TableField(exist = false)
    private String syqhqdmText;

    /******
     * 申请金额
     */
    @TableField(exist = false)
    private String sqje;

    @Override
    public String getId() {
        return fzbzsqmxId;
    }

    @Override
    public void setId(String id) {
        this.fzbzsqmxId = id;
    }
}
