package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglFzbzsqVo
 * @author chris
 * @description 服装标志申请实体类
 * @version 1.0
 * @date 2021-04-25 10:16
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZSQ")
public class ZbglFzbzsqVo extends BaseEntity<String> {

    /******
     * 主键Id
     */
    @TableId("FZBZSQ_ID")
    @TableField("FZBZSQ_ID")
    private String fzbzsqId;

    /******
     * 订单流水号
     */
    @TableField("ORDER_CODE")
    private String orderCode;

    /******
     * 执法人员Id
     */
    @TableField("ZFRY_ID")
    private String zfryId;

    /******
     * 执法人员所在区划Id
     */
    @TableField("XZQH_ID")
    private String xzqhId;

    /******
     * 配发年份
     */
    @TableField("PFNF")
    private String pfnf;

    /******
     * 所属单位Id
     */
    @TableField("ORG_ID")
    private String orgId;

    /******
     * 申请原因
     */
    @TableField("SQYY")
    private String sqyy;

    /******
     * 申请类型代码
     */
    @TableField("SQLXDM")
    private String sqlxdm;

    /******
     * 补发类型代码
     */
    @TableField("BFXZDM")
    private String bfxzdm;

    /******
     * 审批状态代码
     */
    @TableField("SPZTDM")
    private String spztdm;

    /******
     * 申请日期
     */
    @TableField("SQRQ")
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date sqrq;

    /******
     * 申请额度
     */
    @TableField("SQED")
    private String sqed;

    /******
     * 来源方式
     * 01-本人操作
     * 02-他人代理
     */
    @TableField("SOURCE_TYPE")
    private String sourceType;

    /******
     * 操作人Id
     */
    @TableField("OPERATE_USER_ID")
    private String operateUserId;

    /******
     * 申请执法人员Id
     */
    @TableField("APPLY_ZFRY_ID")
    private String applyZfryId;

    /******
     * 备注
     */
    @TableField("REMARK")
    private String remark;

    /******
     * 服装标志申请明细(前台传到后台)
     */
    @TableField(exist = false)
    private String detailInfo;

    /******
     * 所属单位名称
     */
    @TableField(exist = false)
    private String orgName;

    /******
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String zfryXm;

    /*****
     * 身份证件号码
     */
    @TableField(exist = false)
    private String idCard;

    /******
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /******
     * 入职日期
     */
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date rzrq;

    /******
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /******
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /******
     * 申请类型代码Text
     */
    @TableField(exist = false)
    private String sqlxdmText;

    /******
     * 补发性质代码Text
     */
    @TableField(exist = false)
    private String bfxzdmText;

    /******
     * 审批状态代码Text
     */
    @TableField(exist = false)
    private String spztdmText;

    /******
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    @Override
    public String getId() {
        return fzbzsqId;
    }

    @Override
    public void setId(String id) {
        this.fzbzsqId = id;
    }
}
