package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZbglFzbzpfmxVo
 * @author chris
 * @description 配发明细实体类
 * @version 1.0
 * @date 2021-05-28 17:54
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZPFMX")
public class ZbglFzbzpfmxVo extends BaseEntity<String> {

    /***
     * 配发明细表主键id
     */
    @TableId("FZBZPFMX_ID")
    @TableField("FZBZPFMX_ID")
    private String fzbzpfmxId;

    /***
     * 配发表主键id
     */
    @TableField("FZBZPF_ID")
    private String fzbzpfId;

    /***
     * 申请表主键id
     */
    @TableField("FZBZSQ_ID")
    private String fzbzsqId;

    /******
     * 装备名称Id
     */
    @TableField("ZBMC_ID")
    private String zbmcId;

    /******
     * 装备名称
     */
    @TableField("ZBMC")
    private String zbmc;

    /******
     * 申请数量
     */
    @TableField("SQSL")
    private String sqsl;

    /******
     * 适用气候区代码
     */
    @TableField("SYQHQDM")
    private String syqhqdm;

    /******
     * 计量单位
     */
    @TableField("JLDW")
    private String jldw;

    /******
     * 装备尺寸
     */
    @TableField("ZBCC")
    private String zbcc;

    /******
     * 装备单价(单位:元)
     */
    @TableField("ZBDJ")
    private String zbdj;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用人群代码
     */
    @TableField("SYRQDM")
    private String syrqdm;

    /******
     * 期满换发年限
     */
    @TableField("QMHFNX")
    private String qmhfnx;

    /******
     * 期满换发年份
     */
    @TableField("QMHFNF")
    private String qmhfnf;

    /******
     * 已配发数量
     */
    @TableField("YPFSL")
    private String ypfsl;

    /******
     * 首次配发年份
     */
    @TableField(exist = false)
    private String scpfnf;

    /******
     * 期满换发数量
     */
    @TableField(exist = false)
    private String qmhfsl;

    /******
     * 装备分类状态Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    /******
     * 适用气候区代码Text
     */
    @TableField(exist = false)
    private String syqhqdmText;

    /******
     * 配发数量
     */
    @TableField(exist = false)
    private String pfsl;

    @Override
    public String getId() {
        return fzbzpfmxId;
    }

    @Override
    public void setId(String id) {
        this.fzbzpfmxId = id;
    }
}
