package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglFzbzpfjlVo
 * @author hufanghua
 * @description 服装标志配发实体类
 * @version 1.0
 * @date 2021-05-25 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZPFJL")
public class ZbglFzbzpfjlVo extends BaseEntity<String> {

    /***
     * 主键id
     */
    @TableId("FZBZPFJL_ID")
    private String fzbzpfjlId;

    /***
     * 配发表主键id
     */
    @TableField("FZBZPF_ID")
    private String fzbzpfId;

    /***
     * 申请表主键id
     */
    @TableField("FZBZSQ_ID")
    private String fzbzsqId;

    /******
     * 服装标志配发类型
     */
    @TableField("FZBZPFLX")
    private String fzbzpflx;

    /******
     * 装备名称Id
     */
    @TableField("ZBMC_ID")
    private String zbmcId;

    /******
     * 装备名称
     */
    @TableField("ZBMC")
    private String zbmc;

    /******
     * 申请数量
     */
    @TableField("SQSL")
    private String sqsl;

    /******
     * 适用气候区代码
     */
    @TableField("SYQHQDM")
    private String syqhqdm;

    /******
     * 计量单位
     */
    @TableField("JLDW")
    private String jldw;

    /******
     * 装备尺寸
     */
    @TableField("ZBCC")
    private String zbcc;

    /******
     * 装备单价(单位:元)
     */
    @TableField("ZBDJ")
    private String zbdj;

    /******
     * 装备分类代码
     */
    @TableField("ZBFLDM")
    private String zbfldm;

    /******
     * 适用人群代码
     */
    @TableField("SYRQDM")
    private String syrqdm;

    /******
     * 期满换发年限
     */
    @TableField("QMHFNX")
    private String qmhfnx;

    /******
     * 期满换发年份
     */
    @TableField("QMHFNF")
    private String qmhfnf;

    /******
     * 配发数量
     */
    @TableField("PFSL")
    private String pfsl;

    /******
     * 配发人Id
     */
    @TableField("PFR_ID")
    private String pfrId;

    /******
     * 配发人单位Id
     */
    @TableField("PFR_ORG_ID")
    private String pfrOrgId;

    /******
     * 配发日期
     */
    @TableField("PFRQ")
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date pfrq;

    /******
     * 执法人员Id
     */
//    @TableField("ZFRY_ID")
    @TableField(exist = false)
    private String zfryId;

    /******
     * 执法人员所在区划Id
     */
//    @TableField("XZQH_ID")
    @TableField(exist = false)
    private String xzqhId;

    /******
     * 申请人所属单位Id
     */
//    @TableField("SQR_ORG_ID")
    @TableField(exist = false)
    private String sqrOrgId;

    /******
     * 申请原因
     */
//    @TableField("SQYY")
    @TableField(exist = false)
    private String sqyy;

    /******
     * 申请类型代码
     */
//    @TableField("SQLXDM")
    @TableField(exist = false)
    private String sqlxdm;

    /******
     * 补发类型代码
     */
//    @TableField("BFXZDM")
    @TableField(exist = false)
    private String bfxzdm;

    /******
     * 审批状态代码
     */
//    @TableField("SPZTDM")
    @TableField(exist = false)
    private String spztdm;

    /******
     * 申请日期
     */
//    @TableField("SQRQ")
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date sqrq;

    /******
     * 申请额度
     */
//    @TableField("SQED")
    @TableField(exist = false)
    private String sqed;

    /******
     * 申请备注
     */
//    @TableField("SQBZ")
    @TableField(exist = false)
    private String sqbz;

    /******
     * 配发人名称
     */
    @TableField(exist = false)
    private String pfrName;

    /******
     * 配发人所属单位名称
     */
    @TableField(exist = false)
    private String pfrOrgName;

    /******
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String zfryXm;

    /*****
     * 身份证件号码
     */
    @TableField(exist = false)
    private String idCard;

    /******
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /******
     * 入职日期
     */
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date rzrq;

    /******
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /******
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /******
     * 申请类型代码Text
     */
    @TableField(exist = false)
    private String sqlxdmText;

    /******
     * 补发性质代码Text
     */
    @TableField(exist = false)
    private String bfxzdmText;

    /******
     * 审批状态代码Text
     */
    @TableField(exist = false)
    private String spztdmText;

    /******
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    /******
     * 申请人所属单位名称
     */
    @TableField(exist = false)
    private String sqrOrgName;

    /******
     * 首次配发年份
     */
    @TableField(exist = false)
    private String scpfnf;

    /******
     * 期满换发数量
     */
    @TableField(exist = false)
    private String qmhfsl;

    /******
     * 装备分类状态Text
     */
    @TableField(exist = false)
    private String zbfldmText;

    /******
     * 适用人群代码Text
     */
    @TableField(exist = false)
    private String syrqdmText;

    /******
     * 适用气候区代码Text
     */
    @TableField(exist = false)
    private String syqhqdmText;

    @Override
    public String getId() {
        return fzbzpfjlId;
    }

    @Override
    public void setId(String id) {
        this.fzbzpfjlId = id;
    }
}
