package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglFzbzpfVo
 * @author hufanghua
 * @description 服装标志配发实体类
 * @version 1.0
 * @date 2021-05-25 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZPF")
public class ZbglFzbzpfVo extends BaseEntity<String> {

    /****
     * 主键Id
     */
    @TableId("FZBZPF_ID")
    @TableField("FZBZPF_ID")
    private String fzbzpfId;

    /******
     * 审批表主键Id
     */
    @TableField("FZBZSP_ID")
    private String fzbzspId;

    /******
     * 申请表主键Id
     */
    @TableField("FZBZSQ_ID")
    private String fzbzsqId;

    /******
     * 订单流水号
     */
    @TableField("ORDER_CODE")
    private String orderCode;

    /******
     * 执法人员Id
     */
    @TableField("ZFRY_ID")
    private String zfryId;

    /******
     * 执法人员所在区划Id
     */
    @TableField("XZQH_ID")
    private String xzqhId;

    /******
     * 配发年份
     */
    @TableField("PFNF")
    private String pfnf;

    /******
     * 申请人所属单位Id
     */
    @TableField("SQR_ORG_ID")
    private String sqrOrgId;

    /******
     * 申请原因
     */
    @TableField("SQYY")
    private String sqyy;

    /******
     * 申请类型代码
     */
    @TableField("SQLXDM")
    private String sqlxdm;

    /******
     * 补发类型代码
     */
    @TableField("BFXZDM")
    private String bfxzdm;

    /******
     * 审批状态代码
     */
    @TableField("SPZTDM")
    private String spztdm;

    /******
     * 申请日期
     */
    @TableField("SQRQ")
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date sqrq;

    /******
     * 申请额度
     */
    @TableField("SQED")
    private String sqed;

    /******
     * 申请备注
     */
    @TableField("SQBZ")
    private String sqbz;

    /******
     * 审批人Id
     */
    @TableField("SPR_ID")
    private String sprId;

    /******
     * 审批人所属单位Id
     */
    @TableField("SPR_ORG_ID")
    private String sprOrgId;

    /******
     * 审批说明
     */
    @TableField("SPSM")
    private String spsm;

    /******
     * 审批日期
     */
    @TableField("SPRQ")
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date sprq;

    /******
     * 审批备注
     */
    @TableField("SPBZ")
    private String spbz;

    /******
     * 配发状态代码
     */
    @TableField("PFZTDM")
    private String pfztdm;

    /******
     * 服装标志申请明细(前台传到后台)
     */
    @TableField(exist = false)
    private String detailInfo;

    /******
     * 服装标志配发明细(前台传到后台)
     */
    @TableField(exist = false)
    private String peiFaDetailInfo;

    /******
     * 申请人所属单位名称
     */
    @TableField(exist = false)
    private String sqrOrgName;

    /******
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String zfryXm;

    /*****
     * 身份证件号码
     */
    @TableField(exist = false)
    private String idCard;

    /******
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /******
     * 入职日期
     */
    @TableField(exist = false)
    @JSONField(format = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date rzrq;

    /******
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /******
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /******
     * 申请类型代码Text
     */
    @TableField(exist = false)
    private String sqlxdmText;

    /******
     * 补发性质代码Text
     */
    @TableField(exist = false)
    private String bfxzdmText;

    /******
     * 审批状态代码Text
     */
    @TableField(exist = false)
    private String spztdmText;

    /******
     * 配发状态代码Text
     */
    @TableField(exist = false)
    private String pfztdmText;

    /******
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhName;

    /******
     * 审批人名称
     */
    @TableField(exist = false)
    private String sprName;

    /******
     * 审批人所属单位名称
     */
    @TableField(exist = false)
    private String sprOrgName;

    @Override
    public String getId() {
        return fzbzpfId;
    }

    @Override
    public void setId(String id) {
        this.fzbzpfId = id;
    }
}
