package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglFzbzhzspVo
 * @author hufanghua
 * @description 服装标志汇总审批
 * @version 1.0
 * @date 2021-07-12 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZHZSP")
public class ZbglFzbzhzspVo extends BaseEntity<String> {

    /***
     * 主键id
     */
    @TableId("FZBZHZSP_ID")
    private String fzbzhzspId;

    /******
     * 服装标志汇总上报id
     */
    private String fzbzhzsbId;

    /******
     * 服装标志汇总上报id
     */
    @TableField(exist = false)
    private String fzbzsqId;

    /******
     * 审批人
     */
    private String sprxm;

    /******
     * 审批人id
     */
    private String sprid;


    /******
     * 审批状态
     */
    private String spzt;

    /******
     * 审批结果txet
     */
    @TableField(exist = false)
    private String spztText;

    /******
     * 审批意见
     */
    private String spyj;

    /******
     * 审批单位id
     */
    private String spdwid;

    /******
     * 审批单位id
     */
    @TableField(exist = false)
    private String spdwmc;

    /******
     * 审批日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date sprq;

    @Override
    public String getId() {
        return fzbzhzspId;
    }

    @Override
    public void setId(String id) {
        this.fzbzhzspId = id;
    }
}
