package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbglFzbzhzsbVo
 * @author hufanghua
 * @description 服装标志汇总上报
 * @version 1.0
 * @date 2021-07-12 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZHZSB")
public class ZbglFzbzhzsbVo extends BaseEntity<String> {

    /***
     * 主键id
     */
    @TableId("FZBZHZSB_ID")
    private String fzbzhzsbId;

    /******
     * 服装标志申批ID
     */
    private String fzbzspId;

    /******
     * 编号
     */
    private String bh;

    /******
     * 填报人
     */
    private String tbrxm;

    /******
     * 填报人id
     */
    private String tbrid;

    /******
     * 填报意见
     */
    private String tbyj;

    /******
     * 申请总额
     */
    private String sqze;

    /******
     * 上报单位id
     */
    private String sbdwid;

    /******
     * 上报单位id
     */
    @TableField(exist = false)
    private String sbdwmc;

    /******
     * 审批状态
     */
    private String spzt;

    /******
     * 审批日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date tbrq;

    /******
     * 审批结果txet
     */
    @TableField(exist = false)
    private String spztText;

    /******
     * 明细信息
     */
    @TableField(exist = false)
    private String detailInfo;

    /******
     * 服装标志申请ID
     */
    private String fzbzsqId;

    /******
     * 服装标志申请ID状态
     */
    private String spIdZt;

    @Override
    public String getId() {
        return fzbzhzsbId;
    }

    @Override
    public void setId(String id) {
        this.fzbzhzsbId = id;
    }
}
