package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className GrnddeVo
 * @author hufanghua
 * @description 个人年度定额实体类
 * @version 1.0
 * @date 2021-04-13 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_GRNDDE")
public class GrnddeVo extends BaseEntity<String> {

    /***
     * 主键id
     */
    @TableId("GRNDDE_ID")
    private String grnddeId;

    /******
     * 执法人员信息ID
     */
    private String zfryxxId;

    /******
     * 年度定额
     */
    private String ndde;

    /******
     * 规定的年度定额
     */
    private String gdndde;

    /******
     * 可用额度
     */
    private String kyed;

    /******
     * 备注
     */
    private String bz;

    /******
     * 年份
     */
    private String nf;

    /******
     * 上年度结余
     */
    private String sndjy;

    /******
     * 最终年度定额
     */
    private String zzndde;

    /******
     * 姓名
     */
    @TableField(exist = false)
    private String xm;

    /******
     * 性别
     */
    @TableField(exist = false)
    private String xb;

    /******
     * 性别
     */
    @TableField(exist = false)
    private String xbText;

    /******
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /******
     * 身份证号
     */
    @TableField(exist = false)
    private String idCard;

    /******
     * 所属单位
     */
    @TableField(exist = false)
    private String orgName;

    /******
     * 所属单位id
     */
    private String ssdwid;

    /******
     * 定额方式
     */
    @TableField(exist = false)
    private String demc;

    /******
     * 定额方式text
     */
    @TableField(exist = false)
    private String demcText;

    /******
     * 年度
     */
    @TableField(exist = false)
    private String nd;

    /******
     * 机构范围
     */
    @TableField(exist = false)
    private String range;

    /******
     * 个人定额信息
     */
    @TableField(exist = false)
    private String details;


    @Override
    public String getId() {
        return grnddeId;
    }

    @Override
    public void setId(String id) {
        this.grnddeId = id;
    }
}
