package com.kdgcsoft.jt.xzzf.dubbo.fzbz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className FzbzhsdjVo
 * @author hufanghua
 * @description 服装回收实体类
 * @version 1.0
 * @date 2021-04-22 11:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_FZBZ + "ZBGL_FZBZHS")
public class FzbzhsdjVo extends BaseEntity<String> {

    /***
     * 主键id
     */
    @TableId("HS_ID")
    private String hsId;

    /******
     * 执法人员姓名
     */
    private String zfryXm;

    /******
     * 执法人员id
     */
    private String zfryId;

    /******
     * 回收原因
     */
    private String hsyy;

    /******
     * 回收原因
     */
    @TableField(exist = false)
    private String hsyyText;

    /******
     * 操作人员
     */
    private String czry;

    /******
     * 执法证号
     */
    private String zfzh;

    /******
     * 所在单位id
     */
    private String szdwid;

    /******
     * 所在单位名称
     */
    private String szdwmc;

    /******
     * 回收单位id
     */
    private String hsdwid;

    /******
     * 回收单位名称
     */
    private String hsdwmc;

    /******
     * 回收日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date hsrq;

    /******
     * 种类编码
     */
    @TableField(exist = false)
    private String zlbm;

    /******
     * 品类编码
     */
    @TableField(exist = false)
    private String plbm;

    /******
     * 明细详情
     */
    @TableField(exist = false)
    private String details;

    @Override
    public String getId() {
        return hsId;
    }

    @Override
    public void setId(String id) {
        this.hsId = id;
    }
}
