package com.kdgcsoft.jt.xzzf.dubbo.fxczf.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 黑名单车辆表
 * @author zd
 * @since 2020-08-13
 */
@Data
@TableName("FCXZF_HMCCL_HMCCLB")
public class HmdclVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 黑名单车辆ID
     */
    @TableId
    private String hmdclid;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 上传标识
     */
    private String scbs;

    /**
     * 预警时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date yjsj;

    /**
     * 出入境类型：针对黑名单车辆，可从治超系统中获取出入境类型数据。
     * 1:驶入2：驶出（或者是新加入的）3：中交没有推送驶出标识的淮北境外的车辆
     */
    private String crjlx;

    private String name;

    /**
     * 出入境类型：针对黑名单车辆，可从治超系统中获取出入境类型数据。
     * 1:驶入2：驶出（或者是新加入的）3：中交没有推送驶出标识的淮北境外的车辆
     */
    @TableField(exist = false)
    private String crjlxValue;

    @TableField(exist = false)
    private String hmdly;

    @TableField(exist = false)
    private String[] jrrq;

    @TableField(exist = false)
    private String jrrqSta;

    @TableField(exist = false)
    private String jrrqEnd;

    @Override
    public String getId() {
        return hmdclid;
    }

    @Override
    public void setId(String id) {
        this.hmdclid = id;
    }


}
