package com.kdgcsoft.jt.xzzf.common.util.sm4;

/**
 * Created by $(USER) on $(DATE)
 */

import com.kdgcsoft.jt.xzzf.common.constant.Sm4Constant;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Utils {

    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public SM4Utils() {
    }

    public SM4Utils(String secretKey, String iv) {
        this.secretKey = secretKey;
        this.iv = iv;
    }

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_ENCRYPT;

            byte[] keyBytes;
            keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_DECRYPT;

            byte[] keyBytes;
            keyBytes = secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_ENCRYPT;

            byte[] keyBytes;
            byte[] ivBytes;

            keyBytes = secretKey.getBytes();
            ivBytes = iv.getBytes();

            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = SM4.SM4_DECRYPT;

            byte[] keyBytes;
            byte[] ivBytes;
            if (hexString) {
                keyBytes = Util.hexStringToBytes(secretKey);
                ivBytes = Util.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }

            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /******
     * 使用CBC模式加密密码
     * @param plainText 明文
     * @return
     */
    public static String encryptDataWithCBC(String plainText) {
        SM4Utils sm4 = new SM4Utils(Sm4Constant.SM4_KEY, Sm4Constant.SM4_IV);
        System.out.println("CBC模式");
        String cipherText = sm4.encryptData_CBC(plainText);
        System.out.println("密文: " + cipherText);
        return cipherText;
    }

    /******
     * 使用CBC模式解密加密密码
     * @param cipherText 密文
     * @return
     */
    public static String decryptDataWithCBC(String cipherText) {
        SM4Utils sm4 = new SM4Utils(Sm4Constant.SM4_KEY, Sm4Constant.SM4_IV);
        System.out.println("CBC模式");
        String plainText = sm4.decryptData_CBC(cipherText);
        System.out.println("明文: " + plainText);
        return plainText;
    }

    /******
     * 使用ECB模式加密密码
     * @param plainText
     * @return
     */
    public static String encryptDataWithECB(String plainText) {
        SM4Utils sm4 = new SM4Utils(Sm4Constant.SM4_KEY, Sm4Constant.SM4_IV);
        System.out.println("ECB模式");
        String cipherText = sm4.encryptData_ECB(plainText);
        System.out.println("密文: " + cipherText);
        return cipherText;
    }

    /******
     * 使用ECB模式解密加密密码
     * @param cipherText 密文
     * @return
     */
    public static String decryptDataWithECB(String cipherText) {
        SM4Utils sm4 = new SM4Utils(Sm4Constant.SM4_KEY, Sm4Constant.SM4_IV);
        System.out.println("ECB模式");
        String plainText = sm4.decryptData_ECB(cipherText);
        System.out.println("明文: " + plainText);
        return plainText;
    }


    public static void main(String[] args) throws IOException {
        String plainText = "123456";
//        SM4Utils sm4 = new SM4Utils(Sm4Constant.SM4_KEY, Sm4Constant.SM4_IV);
//        System.out.println("CBC模式");
//        String cipherText = sm4.encryptData_CBC(plainText);
//        System.out.println("密文: " + cipherText);
//        System.out.println("");
//
//        plainText = sm4.decryptData_CBC(cipherText);
//        System.out.println("明文: " + plainText);
        System.out.println("CBC密文:" + encryptDataWithCBC(plainText));
        System.out.println("CBC明文:" + decryptDataWithCBC(encryptDataWithCBC(plainText)));
        System.out.println("ECB密文:" + encryptDataWithECB(plainText));
        System.out.println("ECB明文:" + decryptDataWithECB(encryptDataWithECB(plainText)));

    }

}
