package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.http.useragent.Browser;
import cn.hutool.http.useragent.OS;
import cn.hutool.http.useragent.UserAgent;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 浏览器信息工具类
 *
 * @author chris
 */
public class UserAgentUtil {


    public static UserAgent getUserAgent() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String ua = request.getHeader("User-Agent");
        return cn.hutool.http.useragent.UserAgentUtil.parse(ua);
    }

    /**
     * 获取浏览器信息
     *
     * @return
     */
    public static Browser getBrower() {
        return getUserAgent().getBrowser();
    }

    /**
     * 操作系统信息
     *
     * @return
     */
    public static OS getOS() {
        return getUserAgent().getOs();
    }

}
