package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.XmlUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.net.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/****
 * @className SignPdfUtil
 * @author ChrisYolanda
 * @description 电子签章pdf工具类
 * @version 1.0
 * @date 2020-11-03 15:57
 */
@Slf4j
@Component
public class SzzjSignUtil {

    private static XzzfProperties xzzfProperties;

    /****
     * 模板基础路径
     */
    public static final String BASE_PATH = "template";

    /****
     * sign公共路径
     */
    public static final String COMMON_PATH = "pdf";

    /*******
     * 生成Pdf文件
     * @param signAct 签章账号
     * @param filter 盖章的关键字
     * @param tempPath 模板路径
     * @return
     */
    public static byte[] stampSignForPdf(String signAct, String filter, String tempPath) {
        String fullPath = SzzjSignUtil.getTempFileFullPath(tempPath);
        System.out.println("=========试签模板路径:" + fullPath);
        if (BeanUtils.isNotEmpty(fullPath)) {
            if (new File(fullPath).exists()) {
                byte[] stampPdf = FileUtil.getBytesByFile(fullPath);
                return SzzjSignUtil.stampForPdf(stampPdf, signAct, filter, 1);
            } else {
                throw new BusinessException("试签模板文件不存在,请联系管理员");
            }
        } else {
            throw new BusinessException("试签模板路径异常,请联系管理员");
        }
    }

    /*******
     * 生成Pdf文件
     * @param stampPdf
     * @param signAct
     * @param filter
     * @return
     */
    public static byte[] stampForPdf(byte[] stampPdf, String signAct, String filter, int pdfPage) {
        log.info("======================>电子签章接口地址:" + SzzjSignUtil.getSignUrlFromProp());
        if (BeanUtils.isNotEmpty(stampPdf)) {
            try {
                String base64pdf = Base64.encodeBase64String(stampPdf);
                // 调用电子签章接口，返回pdf下载url
                String pdfUrl = SzzjSignUtil.sealAutoZfPdf(base64pdf, signAct, filter, pdfPage);
                if (BeanUtils.isNotEmpty(pdfUrl)) {
                    pdfUrl = pdfUrl.replace("ESS", "yzyy");
                    // 合成之后的pdf，byte数组
                    stampPdf = SzzjSignUtil.getPdf(pdfUrl);
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                return stampPdf;
            }
        } else {
            return null;
        }
    }

    /********
     * 获取pdf信息
     * @param base64pdf Base64加密之后的pdf字节流
     * @param signAct 签章账号
     * @param filter 关键字
     * @param pdfPage pdf总页数
     * @return
     */
    public static String sealAutoZfPdf(String base64pdf, String signAct, String filter, int pdfPage) {
        String result = null;
        try {
            String xmlStr = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>" +
                    "<SEAL_DOC_REQUEST>" +
                    "    <BASE_DATA>" +
                    "        <SYS_ID>jtyst</SYS_ID>" +
                    "        <SYS_PWD>jtyst20201010</SYS_PWD>" +
                    "    </BASE_DATA>" +
                    "    <META_DATA>" +
                    "        <IS_MERGER>false</IS_MERGER>" +
                    "    </META_DATA>" +
                    "    <FILE_LIST>" +
                    "        <TREE_NODE>" +
                    "            <FILE_NO>test.pdf</FILE_NO>" +
                    "            <CJ_TYPE>BASE64</CJ_TYPE>" +
                    "            <MODEL_NAME>" + base64pdf + "</MODEL_NAME>" +
                    "            <IS_MERGER>false</IS_MERGER>" +
                    "            <IS_CODEBAR>false</IS_CODEBAR>" +
                    "            <DOC_TYPE>pdf</DOC_TYPE>" +
                    "            <RULE_TYPE>1</RULE_TYPE>" +
                    "            <RULE_LIST>" +
                    "                <RULE_NODE>" +
                    "                    <RULE_INFO>AUTO_ADD:0," + pdfPage + ",230,345,255," + filter + ")|(4,</RULE_INFO>" +
                    "                    <SEAL_CODE>" + signAct + "</SEAL_CODE>" +
                    "                </RULE_NODE>" +
                    "            </RULE_LIST>" +
                    "        </TREE_NODE>" +
                    "    </FILE_LIST>" +
                    "</SEAL_DOC_REQUEST>";
            Map<String, String> parms = new HashMap();
            parms.put("xmlStr", xmlStr);

            HttpRequest httpRequest = new HttpRequest();
            HttpRespons httpRespons = null;
            httpRespons = httpRequest.sendPost(SzzjSignUtil.getSignUrlFromProp() + "sealAutoPdfZF", parms);
            result = httpRespons.getContent();
            // 调用正式接口，解析xml
            if (SzzjSignUtil.getSignUrlFromProp().contains("59.203.5.104")) {
                Map<String, Object> map = XmlUtil.xmlToMap(result);
                Map<String, Object> map2 = (Map<String, Object>) map.get("FILE_LIST");
                Map<String, Object> map3 = (Map<String, Object>) map2.get("FILE");
                // 合成完的pdf接口地址
                result = (String) map3.get("FILE_URL");
            }
            System.out.println("==========合成完的pdf接口地址：" + result);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            return result;
        }
    }

    /******
     * 根据pdf接口，返回byte数组
     * @param fileUrl
     * @return
     * @throws IOException
     */
    public static byte[] getPdf(String fileUrl) throws IOException {
        if (SzzjSignUtil.getSignUrlFromProp().contains("xzzf-webService")) {
            fileUrl = SzzjSignUtil.getSignUrlFromProp() + "pdfForByte?fileUrl=" + fileUrl;
        }
        System.out.println("==========pdf接口地址：" + fileUrl);
        URL url = new URL(fileUrl);
        //字节输入流
        InputStream is = url.openStream();
        //字节流转字符流
        DataInputStream dataInputStream = new DataInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] chs = new byte[1024];
        int len = 0;
        while ((len = dataInputStream.read(chs)) != -1) {
            bos.write(chs, 0, len);
        }
        bos.flush();
        bos.close();
        is.close();
        dataInputStream.close();
        byte[] bytes = bos.toByteArray();
        System.out.println("==========电子签章接口返回pdf大小：" + bytes.length);
        return bytes;
    }

    /*****
     * 赋值配置文件
     * @param xzzfProperties
     */
    @Autowired
    public void setXzzfProperties(XzzfProperties xzzfProperties) {
        SzzjSignUtil.xzzfProperties = xzzfProperties;
    }

    /*****
     * 获取电子签章地址
     * @return
     */
    public static String getSignUrlFromProp() {
        return xzzfProperties.getSignUrl();
    }

    /*****
     * 获取模板文件全路径
     * @return
     */
    public static String getTempFileFullPath(String filePath) {
        //初始定义模板公共路径
        String tempCommonPath;
        if (xzzfProperties.isTempFileMode()) {
            //获取服务器项目根路径
            tempCommonPath = new File(System.getProperty("user.dir")) + File.separator + BASE_PATH + File.separator + COMMON_PATH + File.separator;
        } else {
            //获取的项目项目打包后在target路径
            tempCommonPath = SzzjSignUtil.class.getClassLoader().getResource("").getPath() + BASE_PATH + File.separator + COMMON_PATH + File.separator;
        }

        //返回模板路径
        return tempCommonPath + filePath;

    }
}
