package com.kdgcsoft.jt.xzzf.common.util;

import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;
import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.constants.DictConstant;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/****
 * @className SysUtil
 * @author chris
 * @description 系统工具类
 * @version 1.0
 * @date 2019-12-30 16:20
 */
@Component
public class SysUtils {

    private static ShiroCasProperties shiroCasProperties;

    /******
     * 获取当前登录用户的信息
     * @return
     */
    public static SysUser getCurUser() {
        //通过shiro获取用户信息
        LoginUser loginUser = ShiroUtil.getLoginUser();
        SysUser sysUser = new SysUser();
        if (!shiroCasProperties.isShiroEnable() || loginUser == null) {
            sysUser.setUserId("40A26A1CACF34E978EDB98BAFE816ED5");
            sysUser.setName("超级管理员");
            sysUser.setUserName("admin");
            sysUser.setOrgId("A3E3A2810E4E4C1E9ADEA2C09EB03849");
            sysUser.setOrgCode("3400000000");
            sysUser.setOrgName("安徽省执法局");
            sysUser.setXzqhId("340000");
            sysUser.setSuperAdmin(DictConstants.DICT_CODE_YES_NO_1);
            sysUser.setZfryid("6C238163CC4B4DAEBF41B7595473E6C3");
        } else {
            sysUser = loginUser.getSysUser();
        }

        return sysUser;
    }

    /****
     * 获取当前用户具有的菜单权限
     * @return
     */
    public static List<AuthMenuVo> getCurUserMenu() {
        //通过shiro获取用户信息
        LoginUser loginUser = ShiroUtil.getLoginUser();
        List<AuthMenuVo> menuInfo = loginUser.getMenuInfo();
        return menuInfo;
    }

    /******
     * 判断当前登录用户是否超级管理员
     * @return
     */
    public static boolean curUserIsSuperAdmin() {
        return DictConstant.DICT_CODE_YES_NO_1.equals(SysUtils.getCurUser().getSuperAdmin());
    }

    /******
     * 获取当前用户的组织机构Id
     * @return
     */
    public static String getCurUserOrgId() {
        return SysUtils.getCurUser().getOrgId();
    }

    @Autowired
    public void setShiroCasProperties(ShiroCasProperties shiroCasProperties) {
        SysUtils.shiroCasProperties = shiroCasProperties;
    }
}
