package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import lombok.extern.log4j.Log4j2;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author
 */
@Log4j2
public class SMSSenderUtils {

    /***
     * 根据配置文件，决定调用哪个接口
     */
    private static String smsSender = PropertyUtil.getProperty("smsService");

    /**
     * 多线程发送短信
     */
    public static void threadSend(List<String> list, String meg) {
        Map<Long, Integer> map = new HashMap<Long, Integer>();
        Thread t = new MyThread(list, map, meg);
//        map.put(t.getId(),Integer.valueOf(0));
        t.start();
        /*try {
            t.join();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }*/
    }

    /**
     * 短信接口
     *
     * @param receivers     接收方电话号码
     * @param msgSmsContent 短信内容
     * @return
     */
    public static String send(String receivers, String msgSmsContent) {
        String message = "";
        if (StrUtil.isEmpty(receivers) || StrUtil.isEmpty(msgSmsContent)) {
            throw new BusinessException("手机号码或短信内容不能为空！");
        }
        if (StrUtil.isNotEmpty(smsSender)) {
            if ("test".equals(smsSender)) {
                message = sendMessage(receivers, msgSmsContent);
            } else if ("prod".equals(smsSender)) {
                message = sendMessage(receivers, msgSmsContent);
            } else {
                log.error("请在配置文件中配置正确（短信调用：test调用测试接口，prod调用厅里正式短信接口，eg：smsService: test）");
                throw new BusinessException("请在配置文件中配置正确！");
            }
        } else {
            throw new BusinessException("请在配置文件中配置相应属性！");
        }

        return message;
    }

    /**
     * 短信接口
     *
     * @param receivers     接收方电话号码
     * @param msgSmsContent 短信内容
     * @return
     */
    public static String sendMessage(String receivers, String msgSmsContent) {
        HttpRequest request = new HttpRequest();
        request.setDefaultContentEncoding("utf-8");
        // 获取到数据
        Map<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("uid", "SL71908");
        paramsMap.put("un", "xxxt");
        paramsMap.put("pw", "aa439e1a338b64d4");
        paramsMap.put("p", receivers);
        paramsMap.put("i", msgSmsContent);
        HttpRespons hr = null;
        // 获取响应
        try {
            hr = request.sendPost("http://10.52.1.104:8098/sms/api/sendMsg.do", paramsMap);
        } catch (IOException e) {
            e.printStackTrace();
        }
        String result = "";
        if (ObjectUtil.isNotNull(hr) && StrUtil.isNotEmpty(hr.getContent())) {
            String content = hr.getContent().replaceAll("\\r", "").replaceAll("\\n", "");
            if ("00".equals(content)) {
                result = "0";
            } else {
                result = hr.getContent();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String send = sendMessage("16655160796", "短信发送");
        System.out.println(send);
    }

}
