package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;

import java.util.regex.Pattern;

/****
 * @className RegexUtils
 * @author chris
 * @description 正则表达式工具类
 * @version 1.0
 * @date 2019-12-28 15:12
 */
public class RegexUtils {

    /*****
     * 验证Email
     * @param email email地址，格式：zhangsan@zuidaima.com，zhangsan@xxx.com.cn，xxx代表邮件服务商
     * @return 验证成功返回true，验证失败返回false
     */
    public static boolean regexEmail(String email) {
        String regex = "\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?";
        return Pattern.matches(regex, email.trim());
    }

    /******
     * 验证身份证号码
     * @param idCard 居民身份证号码15位或18位，最后一位可能是数字或字母
     * @return 验证成功返回true，验证失败返回false
     */
    public static boolean regexIdCard(String idCard) {
        String regex = "[1-9]\\d{13,16}[xX0-9]";
        return Pattern.matches(regex, idCard.trim());
    }

    /******
     * 验证网址信息是否有效
     * @param url 网址信息
     * @return 验证成功返回true，验证失败返回false
     */
    public static boolean regexUrl(String url) {
        String regex = "^(?=^.{3,255}$)(http(s)?:\\/\\/)?(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/\\w+\\.\\w+)*$";
        return Pattern.matches(regex, url.trim());
    }

    /******
     * 验证数字是否符合规则
     * @param num
     * @return
     */
    public static boolean regexNumber(String num) {
        String regex = "^-?\\d+$";
        return Pattern.matches(regex, num.trim());
    }

    /******
     * 验证数字是否符合规则
     * @param num
     * @return
     */
    public static boolean regexFloat(String num) {
        String regex = "^-?\\d+\\.?\\d+$";
        return Pattern.matches(regex, num.trim());
    }

    /******
     * 验证字符串是否是正整数
     * @param str
     * @return
     */
    public static boolean regexPositive(String str){
        String regex = "^[1-9]\\d*$";
        return Pattern.matches(regex, str.trim());
    }

    /******
     * 验证字符串是否是正整数(带两位小数)
     * @param str
     * @return
     */
    public static boolean regexDecimal(String str){
        String regex = "^(([1-9]{1}\\d*)|(0{1}))(\\.\\d{1,2})?$";
        return Pattern.matches(regex, str.trim());
    }

    /******
     * 验证是否是电话号码
     * @param str
     * @return
     */
    public static boolean regexTel(String str){
        // 手机号
        String regexMobile = "^1(3|4|5|6|7|8|9)\\d{9}$";
        // 固定电话(带分机号)
        String regexTel1 = "^((0\\d{2,3})-)(\\d{7,8})(-(\\d{3,}))?$";
        // 固定电话(不带分机号)
        String regexTel2 = "^(\\d{7,8})(-(\\d{3,}))?$/";

        boolean result1 = Pattern.matches(regexMobile, str.trim());
        boolean result2 = Pattern.matches(regexTel1, str.trim());
        boolean result3 = Pattern.matches(regexTel2, str.trim());

        if(result1 == false && result2 == false && result3 == false){
            return false;
        }else{
            return true;
        }
    }

    /******
     * 验证日期
     * @param str
     * @return
     */
    public static boolean regexDate(String str){
        // yyyy-MM-dd格式
        String rexpDate1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$";
        // yyyy-MM-dd HH:mm:ss格式
        //  String rexpTime1 = "((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)) ([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";

        // yyyy/MM/dd格式
        //  String rexpDate2 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})\\/(((0[13578]|1[02])\\/(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)\\/(0[1-9]|[12][0-9]|30))|(02\\/(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))\\/02\\/29)$";
        //   yyyy/MM/dd HH:mm:ss格式
        //    String rexpTime2 = "((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})\\/(((0[13578]|1[02])\\/(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)\\/(0[1-9]|[12][0-9]|30))|(02\\/(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))\\/02\\/29)) ([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
       return Pattern.matches(rexpDate1, str.trim());
    }

    /******
     * 验证年月
     * @param str
     * @return
     */
    public static boolean regexYearAndMonth(String str){
        // yyyy-MM格式
        String rexpDate1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[123456789]|1[012]))))$";
        return Pattern.matches(rexpDate1, str.trim());
    }

    /******
     * 验证是否是经度
     * @param str
     * @return
     */
    public static boolean regexLongitude(String str){
        String regex = "^(\\-|\\+)?(((\\d|[1-9]\\d|1[0-7]\\d|0{1,3})\\.\\d{0,15})|(\\d|[1-9]\\d|1[0-7]\\d|0{1,3})|180\\.0{0,15}|180)$";
        return Pattern.matches(regex, str.trim());
    }

    /******
     * 验证是否是纬度
     * @param str
     * @return
     */
    public static boolean regexLaitude(String str){
        String regex = "^(\\-|\\+)?([0-8]?\\d{1}\\.\\d{0,15}|90\\.0{0,15}|[0-8]?\\d{1}|90)$";
        return Pattern.matches(regex, str.trim());
    }

    /******
     * 验证字符串是否是传真
     * @param str
     * @return
     */
    public static boolean regexFax(String str){
        String regex = "^(?:\\d{3,4}-)?\\d{7,8}(?:-\\d{1,6})?$";
        return Pattern.matches(regex, str.trim());
    }

    public static void main(String[] args) {
//        String data = "http://192.168.61.248:8080|";
//        boolean ret = RegexUtils.regexUrl(data);
//        System.out.println("===========ret:" + ret);
        String content = "admin";

        //随机生成密钥
        byte[] key = SecureUtil.generateKey(SymmetricAlgorithm.AES.getValue()).getEncoded();
        //构建
        SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, key);
//        //加密
//        byte[] encrypt = aes.encrypt(content);
//        //解密
//        byte[] decrypt = aes.decrypt(encrypt);
        //加密为16进制表示
        String encryptHex = aes.encryptHex(content);
        //解密为字符串
        String decryptStr = aes.decryptStr(encryptHex);

        System.out.println("===============key:"+key);
        System.out.println("===============encryptHex:"+encryptHex);
        System.out.println("===============decryptStr:"+decryptStr);
    }
}
