package com.kdgcsoft.jt.xzzf.common.util;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.*;

import java.io.BufferedOutputStream;
import java.io.IOException;

/**
 * <p>
 *  文书生成二维码工具类
 * </p>
 *
 * @author 周杰
 * @since 2020-05-22
 */
public class QRcodePrint {
    /**
     *
     * @param bos 生成的有水印的pdf
     * @param input 原始pdf
     * @param permission 权限码
     * @throws DocumentException
     * @throws IOException
     */
    public static Boolean setQRmark(BufferedOutputStream bos, String input, int permission, String ewmImageurl)
            throws DocumentException, IOException {
        PdfReader reader = new PdfReader(input);
        PdfStamper stamper = new PdfStamper(reader, bos);
        int total = reader.getNumberOfPages() + 1;
        PdfContentByte content;
        BaseFont base = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.EMBEDDED);
        PdfGState gs = new PdfGState();
        for (int i = 1; i < total; i++) {
            content = stamper.getOverContent(i);// 在内容上方加水印
            //content = stamper.getUnderContent(i);//在内容下方加水印
            gs.setFillOpacity(0.1f);
            content.beginText();
            content.setFontAndSize(base, 50);
            content.setTextMatrix(70, 200);
            Image ewmimage = Image.getInstance(ewmImageurl);
            ewmimage.setAbsolutePosition(30, 725);
            ewmimage.scaleToFit(100, 100);
            ewmimage.setGrayFill(0.1f);
            content.addImage(ewmimage);
            content.setFontAndSize(base, 8);
            content.showTextAligned(Element.ALIGN_CENTER, "", 300, 10, 0);
            content.endText();
        }
        stamper.close();
        reader.close();
        bos.close();
        return true;
    }

    /**
     *
     * @param bos 生成的有水印的pdf
     * @param input 原始pdf
     * @param permission 权限码
     * @throws DocumentException
     * @throws IOException
     */
    public static Boolean setQRmarkOnePage(BufferedOutputStream bos, String input, int permission, String ewmImageurl)
            throws DocumentException, IOException {
        PdfReader reader = new PdfReader(input);
        PdfStamper stamper = new PdfStamper(reader, bos);
        PdfContentByte content;
        BaseFont base = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.EMBEDDED);
        PdfGState gs = new PdfGState();
            content = stamper.getOverContent(1);// 在内容上方加水印
            //content = stamper.getUnderContent(i);//在内容下方加水印
            gs.setFillOpacity(0.1f);
            content.beginText();
            content.setFontAndSize(base, 50);
            content.setTextMatrix(70, 200);
            Image ewmimage = Image.getInstance(ewmImageurl);
            ewmimage.setAbsolutePosition(30, 742);
            ewmimage.scaleToFit(100, 100);
            ewmimage.setGrayFill(0.1f);
            content.addImage(ewmimage);
            content.setFontAndSize(base, 8);
            content.showTextAligned(Element.ALIGN_CENTER, "", 300, 10, 0);
            content.endText();
        stamper.close();
        reader.close();
        bos.close();
        return true;
    }
}
