package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.date.DatePattern;

import java.text.SimpleDateFormat;
import java.util.Date;

/****
 * @className OrderUtils
 * @author chris
 * @description 订单工具类
 * @version 1.0
 * @date 2021-07-16 23:40
 */
public class OrderUtils {

    /****
     * 首发登记订单编号前缀
     */
    public static final String PREFIX_SFDJ = "SFDJ_";

    /****
     * 期满换发订单编号前缀
     */
    public static final String PREFIX_QMHF = "QMHF_";

    /****
     * 补发订单编号前缀
     */
    public static final String PREFIX_BF = "BF_";

    /****
     * 自主选配订单编号前缀
     */
    public static final String PREFIX_ZZXP = "ZZXP_";

    /****
     * 交旧领新订单编号前缀
     */
    public static final String PREFIX_JJLX = "JJLX_";

    /******
     * 生成首发登记订单流水号
     * @return
     */
    public static synchronized String generateSfdjOrderCode() {
        return OrderUtils.generateOrderCode(PREFIX_SFDJ);
    }

    /******
     * 生成期满换发订单流水号
     * @return
     */
    public static synchronized String generateQmhfOrderCode() {
        return OrderUtils.generateOrderCode(PREFIX_QMHF);
    }

    /******
     * 生成补发订单流水号
     * @return
     */
    public static synchronized String generateBfOrderCode() {
        return OrderUtils.generateOrderCode(PREFIX_BF);
    }

    /******
     * 生成自主选配订单流水号
     * @return
     */
    public static synchronized String generateZzxpOrderCode() {
        return OrderUtils.generateOrderCode(PREFIX_ZZXP);
    }

    /******
     * 生成交旧领新订单流水号
     * @return
     */
    public static synchronized String generateJjlxOrderCode() {
        return OrderUtils.generateOrderCode(PREFIX_JJLX);
    }

    /*****
     * 生成订单编号
     * @param prefixCode
     * @return
     */
    public static synchronized String generateOrderCode(String prefixCode) {
        String str = new SimpleDateFormat(DatePattern.PURE_DATETIME_MS_PATTERN).format(new Date());
        Long m = Long.parseLong(str) * 100;
        return prefixCode + Math.abs(m);
    }

}
