package com.kdgcsoft.jt.xzzf.common.util;

import java.util.regex.Pattern;

/**
 * @Description: 数字、中文数字互转
 * @Author: zd
 * @Date: 2020/4/3
 */
public class NumToZH {

    /**
     * 数字转中文数字
     * @param num
     * @return
     */
    public static String numToZH(int num) {
        String n[] = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
        String unit[] = {"", "十", "百", "千"};
        String unit1[] = {"亿", "万"};
        StringBuilder chi = new StringBuilder();

        String temp = Integer.valueOf(num).toString();
        for (int i = 0; i < temp.length(); i++) {
            chi.append(n[Integer.parseInt(String.valueOf(temp.charAt(i)))]);
            chi.append(unit[(temp.length() - i - 1) % 4]);
            if ((temp.length() - i) % 4 == 1) {
                chi.append(unit1[(int) Math.floor((double) (temp.length() - i) / 4) % 2]);
            }
        }
        String ch = chi.toString();
        ch = ch.replaceAll("零千", "零");
        ch = ch.replaceAll("零百", "零");
        ch = ch.replaceAll("零十", "零");
        while (ch.indexOf("零零") > 0) {
            ch = ch.replaceAll("零零", "零");
        }
        ch = ch.replaceAll("零万", "万");
        ch = ch.replaceAll("零亿", "亿");
        ch = ch.replaceAll("亿万", "亿");
        if (ch.indexOf("一十") == 0) {
            ch = ch.replaceAll("一十", "十");
        }
        return ch.substring(0, ch.length() - 1);
    }

    /**
     * 中文数字转数字【十万九千零六十  --> 109060】
     *
     * @param chineseNumber
     * @return
     */
    private static int chineseNumberToInt(String chineseNumber) {
        int result = 0;
        int temp = 1;//存放一个单位的数字如：十万
        int count = 0;//判断是否有chArr
        char[] cnArr = new char[]{'一', '二', '三', '四', '五', '六', '七', '八', '九'};
        char[] chArr = new char[]{'十', '百', '千', '万', '亿'};
        for (int i = 0; i < chineseNumber.length(); i++) {
            boolean b = true;//判断是否是chArr
            char c = chineseNumber.charAt(i);
            for (int j = 0; j < cnArr.length; j++) {//非单位，即数字
                if (c == cnArr[j]) {
                    if (0 != count) {//添加下一个单位之前，先把上一个单位值添加到结果中
                        result += temp;
                        temp = 1;
                        count = 0;
                    }
                    // 下标+1，就是对应的值
                    temp = j + 1;
                    b = false;
                    break;
                }
            }
            if (b) {//单位{'十','百','千','万','亿'}
                for (int j = 0; j < chArr.length; j++) {
                    if (c == chArr[j]) {
                        switch (j) {
                            case 0:
                                temp *= 10;
                                break;
                            case 1:
                                temp *= 100;
                                break;
                            case 2:
                                temp *= 1000;
                                break;
                            case 3:
                                temp *= 10000;
                                break;
                            case 4:
                                temp *= 100000000;
                                break;
                            default:
                                break;
                        }
                        count++;
                    }
                }
            }
            if (i == chineseNumber.length() - 1) {//遍历到最后一个字符
                result += temp;
            }
        }
        return result;
    }

    public static String numZH(String num, String param) {
        /**
         * 2013523zhangjie添加
         * 判断num是否为空
         *
         */
        if (num != null && !"".equalsIgnoreCase(num)) {
            return "第" + numToZH(Integer.parseInt(num)) + param;
        }
        return "";
    }

    //中间加"（）"
    public static String numZHB(String num, String param) {
        /**
         * 2013523zhangjie添加
         * 判断num是否为空
         *
         */
        if (num != null && !"".equalsIgnoreCase(num)) {
            return "第（" + numToZH(Integer.parseInt(num)) + "）" + param;
        }
        return "";
    }

    public static String numToBigZH(int num) {
        String n[] = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
        String unit[] = {"", "拾", "佰", "仟"};
        String unit1[] = {"亿", "万"};
        StringBuilder chi = new StringBuilder();

        String temp = Integer.valueOf(num).toString();
        for (int i = 0; i < temp.length(); i++) {
            chi.append(n[Integer.parseInt(String.valueOf(temp.charAt(i)))]);
            chi.append(unit[(temp.length() - i - 1) % 4]);
            if ((temp.length() - i) % 4 == 1) {
                chi.append(unit1[(int) Math.floor((double) (temp.length() - i) / 4) % 2]);
            }
        }
        String ch = chi.toString();
        ch = ch.replaceAll("零仟", "零");
        ch = ch.replaceAll("零佰", "零");
        ch = ch.replaceAll("零拾", "零");
        while (ch.indexOf("零零") > 0) {
            ch = ch.replaceAll("零零", "零");
        }
        ch = ch.replaceAll("零万", "万");
        ch = ch.replaceAll("零亿", "亿");
        ch = ch.replaceAll("亿万", "亿");
        if (ch.indexOf("壹拾") == 0) {
            ch = ch.replaceAll("壹十", "拾");
        }
        return ch.substring(0, ch.length() - 1);
    }

    /**
     * 字符转大写  改自相应js方法
     */
    public static String numToDX(String n) {
        if (n == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("(0|[1-9]\\d{0,10})(\\.\\d{1,2})?");
        if (pattern.matcher(n).matches()) {
            if ("0".equals(n) || "0.0".equals(n) || "0.00".equals(n))
                return "零元";
            String unit = "仟百拾亿仟佰拾万仟佰拾元角分";
            String str = "";
            n += "00";
            int p = n.indexOf('.');
            if (p >= 0) {
                n = n.substring(0, p) + n.substring(p + 1, p + 3);
            }
            unit = unit.substring(unit.length() - n.length());
            for (int i = 0; i < n.length(); i++) {
                int ff = Integer.valueOf(String.valueOf(n.charAt(i)));
                str += String.valueOf("零壹贰叁肆伍陆柒捌玖".charAt(ff)) + String.valueOf(unit.charAt(i));
            }
            return str.replaceAll("零(仟|佰|拾|角)", "零").replaceAll("(零)+", "零").replaceAll(
                    "零(万|亿|元)", "$1").replaceAll("(亿)万|^壹(拾)", "$1$2").replaceAll(
                    "^元零?|零分", "").replaceAll("元$", "元整");
        } else {
            return "";
        }
    }

    /**
     * 字符中获取数字
     */
    public static String get_StringNum(String n) {
        if (n == null) {
            return "";
        }
        String str = n;
        str = str.trim();
        String str2 = "";
        if (str != null && !"".equals(str)) {
            for (int i = 0; i < str.length(); i++) {
                if (str.charAt(i) >= 48 && str.charAt(i) <= 57) {
                    str2 += str.charAt(i);

                }
            }
        }
        return str2;
    }

    /**
     * 字符串是否为数字
     */
    public static boolean isNumeric(String str) {
        for (int i = str.length(); --i >= 0; ) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
        }
        return true;
    }
}

