package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.scrdc.frame.webframe.core.model.UiTreeNode;

import java.util.ArrayList;
import java.util.List;

/**
 * @author mapp
 */
public class MenuTreeHelper {

    /**
     * 根据完整的菜单列表型数据构建树形结构
     * @param fullMenuList
     * @return
     */
    public static List<UiTreeNode> buildFullMenuTree(List<AuthMenuVo> fullMenuList) {

        List<UiTreeNode> nodelist = new ArrayList<>();
        /*先排序**/
        if(BeanUtils.isNotEmpty(fullMenuList)){
            //先找到所有父节点不在数据列表中的节点作为树的根节点
            for (AuthMenuVo menu : fullMenuList) {
                AuthMenuVo pmenu = CollUtil.findOneByField(fullMenuList, "menuId", menu.getMenuPid());
                /**没有找到父节点切当前节点是可用状态，才会作为根节点***/
                if (pmenu == null ) {
                    UiTreeNode node = convertToNode(menu);
                    nodelist.add(node);
                }
            }

            /**构造一个待处理的节点列表，每个节点只找各自子节点，没有找到子节点说明数据已经构造完成**/
            List<UiTreeNode> todoList = CollUtil.newArrayList(nodelist);
            while (!todoList.isEmpty()) {
                UiTreeNode todonode = todoList.get(0);
                todoList.remove(0);
                for (AuthMenuVo menu : fullMenuList) {
                    if (todonode.getId().equals(menu.getMenuPid().toString())) {
                        //只添加启用状态的菜单
                       /* if(FrameConst.Y == Integer.parseInt(menu.getMenuState())){
                            UiTreeNode child = convertToNode(menu);
                            todonode.addChild(child);
                            todoList.add(child);
                        }*/
                        UiTreeNode child = convertToNode(menu);
                        todonode.addChild(child);
                        todoList.add(child);
                    }
                }
            }
        }
        return nodelist;
    }

    public static UiTreeNode convertToNode(AuthMenuVo menu) {
        UiTreeNode node = new UiTreeNode();
        node.setId(menu.getMenuId());
        node.setText(menu.getMenuName());
        node.setIconCls("icon-server");
        //节点默认关闭
//        node.setState("closed");
        //如果父节点选中，叶子节点中有未选中的处理方式
        node.addAttributes("menuCode", menu.getMenuCode());
        node.addAttributes("menuUrl", menu.getMenuPath());
//        node.addAttributes("openType", menu.getOpenType());
       // node.addAttributes("menuState", menu.getMenuState());
        node.addAttributes("menuIco", "icon-server");
        node.addAttributes("menuType", menu.getMenuType());
        return node;
    }
}
