package com.kdgcsoft.jt.xzzf.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

/**
 * 。
 *
 * @author yeyang
 * @date 2020/11/28
 */
public class KaiYuanUtil {
    /**
     * 获取正确的header
     * @return
     */
    public static HttpHeaders getCorrectHeader() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String timestamp = LocalDateTime.now().format(dateTimeFormatter);
        String nonce = RandomStringUtils.randomAlphanumeric(8);
        String account = "app1606380558815";
        String token = token();
        String sign = DigestUtils.sha1Hex(account + timestamp + nonce + token);

        HttpHeaders header = new HttpHeaders();
        header.add("dm-account", account);
        header.add("dm-timestamp", timestamp);
        header.add("dm-nonce", nonce);
        header.add("dm-sign", sign);
        return header;
    }

    private static String token(){
        RestTemplate restTemplate = new RestTemplate();
        Map map = new HashMap();
        map.put("account","app1606380558815");
        map.put("secretKey","skOk4s4FX5fqxsObEXBkJHs5bJ8pXA0B");


        HttpEntity httpEntity = new HttpEntity(map,null);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl("http://112.29.246.231:6120/token/generate");

        ResponseEntity<String> exchange = restTemplate.exchange(
                builder.build().toString(),
                HttpMethod.POST,
                httpEntity,
                String.class
        );
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(exchange.getBody()).get("token").textValue();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    public static String toJsonString(Object o){
        ObjectMapper mapper = new ObjectMapper();
        String s = null;
        try {
            s = mapper.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println(token());
    }


}
