package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfWriter;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;

/**
 * 图片转pdf工具类
 */
public class ImgToPdfUtil {

    private static String IMAGE_PDF_PATH = "/event/upload/xzzf-xtba/";

    private static final Logger logger = LoggerFactory.getLogger(ImgToPdfUtil.class);

    public static File Pdf(ArrayList<String> imageUrllist, String mOutputPdfFileName) throws IOException, DocumentException {
        // new一个A4纸pdf文档
        Document doc = new Document(PageSize.A4, 0, 0, 1, 0);
        // pdf写入
        PdfWriter.getInstance(doc, new FileOutputStream(mOutputPdfFileName));
        // 打开文档
        doc.open();

        // 图片路径
        String imagePath = "";
        // 图片名称
        String imageName = "";
        ByteArrayOutputStream out = null;
        // 循环图片List，将图片加入到pdf中
        for (int i = 0; i < imageUrllist.size(); i++) {
            // 在pdf创建一页
            doc.newPage();
            // 图片路径
            imagePath = IMAGE_PDF_PATH;
            // 图片名称
            imageName = imageUrllist.get(i);
            String str = imageName.substring(1, 12);
            String str2 = imageName.substring(12, imageName.length());
            out = new ByteArrayOutputStream();
            FtpUtil.downLoad(imagePath+str, str2, out);
            byte[] bytes = out.toByteArray();
            Image png1 = Image.getInstance(bytes);
            float heigth = png1.getHeight();
            float width = png1.getWidth();
            int percent = getPercent2(heigth, width);
            png1.setAlignment(Image.MIDDLE);
            // 表示是原来图像的比例;
            png1.scalePercent(percent + 3);
            doc.add(png1);
        }
        doc.close();
        // 关闭流
        if(out != null){
            out.close();
        }

        // 输出流
        File mOutputPdfFile = new File(mOutputPdfFileName);
        logger.info("文件大小="+mOutputPdfFile.length());
        if(mOutputPdfFile.exists()){
            logger.info("文件存放位置="+mOutputPdfFileName);
        }else{
            logger.info("文件新建");
            mOutputPdfFile.createNewFile();
        }

        // 返回文件输出流
        return mOutputPdfFile;
    }

    public static int getPercent(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        if (h > w) {
            p2 = 297 / h * 100;
        } else {
            p2 = 210 / w * 100;
        }
        p = Math.round(p2);
        return p;
    }

    public static int getPercent2(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 530 / w * 100;
        p = Math.round(p2);
        return p;
    }

    /** 
    * @Description: 通过图片路径及生成pdf路径，将图片转成pdf
    * @Author: zd
    * @Date: 2020/06/02
    */ 
    public boolean imgOfPdf(String imgUrl, String pdfUrl, String pdfName) throws IOException, DocumentException {
        // 图片list集合
        ArrayList<String> imageUrllist = new ArrayList<String>();
        String[] imgUrls = imgUrl.split(",");
        for (int i=0; i<imgUrls.length; i++) {
            logger.info("图片名称="+imgUrls[i]);
            imageUrllist.add(imgUrls[i]);
        }

        // 生成pdf
        File file = this.Pdf(imageUrllist, pdfUrl+File.separator+pdfName);

        return true;

    }
}
