package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;

/**
 * ID 工具类
 *
 * @author chris
 */
@Component
public class IDUtil {

    @Autowired
    private RedisUtil redisUtil;

    private static IDUtil idUtil = new IDUtil();

    @PostConstruct
    public void init() {
        idUtil.redisUtil = this.redisUtil;
    }

    /**
     * UUID
     *
     * @return
     */
    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    /**
     * 雪花算法生成id
     *
     * @return
     */
    public static Snowflake snowflake() {
        return Singleton.get(Snowflake.class, getWorkId(), getDataCenterId());
    }

    /**
     * redis的incre自增命令生成id
     * 共20位：前15位日期，后5位redis生成的值（不足5位补0）
     *
     * @return
     */
    public static String redisId() {
        Long increId = idUtil.redisUtil.increForId();
        StringBuffer sb = new StringBuffer();
        // 不足5位补0
        int length = (increId + "").length();
        if (length < 5) {
            for (int i = 0; i < 5 - length; i++) {
                sb = sb.append("0");
            }
        }
        sb.append(increId);
        // 前15位日期，后5位由redis生成的id，不足5位补0
        String id = DateUtil.format(new Date(), "yyyyMMddHHmmsss") + sb;
        return id;
    }

    /**
     * 终端ID
     */
    private static long getWorkId() {
        try {
            String hostAddress = SystemUtil.getHostInfo().getAddress();
            int[] ints = StrUtil.splitToInt(hostAddress, ".");
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return (sums % 32);
        } catch (Exception e) {
            // 如果获取失败，则使用随机数备用
            return RandomUtils.nextLong(0, 31);
        }
    }

    /**
     * 数据中心ID
     */
    private static long getDataCenterId() {
        try {
            long hash = HashUtil.tianlHash(SystemUtil.getHostInfo().getName());
            return (hash % 32);
        } catch (Exception e) {
            // 如果获取失败，则使用随机数备用
            return RandomUtils.nextLong(0, 31);
        }
    }

    public static void main(String[] args) {
        System.out.println("雪花算法生成id：" + IDUtil.snowflake().nextId());
    }
}
