package com.kdgcsoft.jt.xzzf.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.*;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Vector;

/**
 * HTTP请求对象
 */
public class HttpRequest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultContentEncoding;

    public HttpRequest() {
        this.defaultContentEncoding = Charset.defaultCharset().name();
    }

    /**
     * 发送GET请求
     *
     * @param urlString URL地址
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendGet(String urlString) throws IOException {
        return this.send(urlString, "GET", null, null, false);
    }

    /**
     * 发送GET请求
     *
     * @param urlString URL地址
     * @param paramsMap 参数集合
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendGet(String urlString, Map<String, String> paramsMap) throws IOException {
        return this.send(urlString, "GET", paramsMap, null, false);
    }

    /**
     * 发送GET请求
     *
     * @param urlString    URL地址
     * @param paramsMap    参数集合
     * @param propertysMap 请求属性
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendGet(String urlString, Map<String, String> paramsMap,
                               Map<String, String> propertysMap) throws IOException {
        return this.send(urlString, "GET", paramsMap, propertysMap, false);
    }

    /**
     * 发送POST请求
     *
     * @param urlString URL地址
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendPost(String urlString) throws IOException {
        return this.send(urlString, "POST", null, null, false);
    }

    /**
     * 发送POST请求
     *
     * @param urlString URL地址
     * @param paramsMap 参数集合
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendPost(String urlString, Map<String, String> paramsMap)
            throws IOException {
        return this.send(urlString, "POST", paramsMap, null, false);
    }

    /**
     * 发送POST请求
     *
     * @param urlString    URL地址
     * @param paramsMap    参数集合
     * @param propertysMap 请求属性
     * @return 响应对象
     * @throws IOException
     */
    public HttpRespons sendPost(String urlString, Map<String, String> paramsMap,
                                Map<String, String> propertysMap) throws IOException {
        return this.send(urlString, "POST", paramsMap, propertysMap, false);
    }

	/**
	 * 发送POST请求
	 *
	 * @param urlString    URL地址
	 * @param paramsMap    参数集合
	 * @param flag 		   是否返回文件流
	 * @return 响应对象
	 * @throws IOException
	 */
	public HttpRespons sendPost(String urlString, Map<String, String> paramsMap, boolean flag) throws IOException {
		return this.send(urlString, "POST", paramsMap, null, flag);
	}

    /**
     * 发送HTTP请求
     *
     * @param urlString
     * @return 响映对象
     * @throws IOException
     */
	/**
	 * 发送HTTP请求
	 * @param urlString		URL地址
	 * @param method		请求类型
	 * @param parametersMap	请求参数
	 * @param propertysMap	请求书属性
	 * @param flag			是否返回文件流
	 * @return
	 * @throws IOException
	 */
    private HttpRespons send(String urlString, String method, Map<String, String> parametersMap,
							 Map<String, String> propertysMap, boolean flag)
            throws IOException {
        HttpURLConnection urlConnection = null;

        if (method.equalsIgnoreCase("GET") && parametersMap != null) {
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : parametersMap.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(URLEncoder.encode(parametersMap.get(key), "UTF-8"));
                i++;
            }
            urlString += param;
        }
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        URL url = new URL(urlString);
        urlConnection = (HttpURLConnection) url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setConnectTimeout(30000);
        urlConnection.setReadTimeout(30000);
        if (propertysMap != null) {
            for (String key : propertysMap.keySet()) {
                urlConnection.addRequestProperty(key, propertysMap.get(key));
            }
        }
        if (method.equalsIgnoreCase("POST") && parametersMap != null) {
            StringBuffer param = new StringBuffer();
            for (String key : parametersMap.keySet()) {
                param.append("&");
                param.append(key).append("=").append(URLEncoder.encode(parametersMap.get(key), "UTF-8"));
            }
            urlConnection.getOutputStream().write(param.toString().getBytes());
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
        }

        return this.makeContent(urlString, urlConnection, flag);
    }

	/**
	 * 得到响应对象
	 * @param urlString		URL地址
	 * @param urlConnection
	 * @param flag			是否返回文件流
	 * @return
	 * @throws IOException
	 */
    private HttpRespons makeContent(String urlString, HttpURLConnection urlConnection,
									boolean flag) throws IOException {
        HttpRespons httpResponse = new HttpRespons();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()){
            InputStream in;
            int code = urlConnection.getResponseCode();
            if (code == 200) {
                in = urlConnection.getInputStream(); // 得到网络返回的输入流
            } else {
                in = urlConnection.getErrorStream(); // 得到网络返回的输入流
            }

			byte[] responseByte = null;
			StringBuffer temp = new StringBuffer();
			// true返回文件流（byte[]格式）
			if(flag){
				byte[] buffer = new byte[1024];
				int len = 0;
				while ((len = in.read(buffer)) != -1) {
					outputStream.write(buffer, 0, len);
				}
				outputStream.flush();
				responseByte = outputStream.toByteArray();
			}else {
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, defaultContentEncoding));
				httpResponse.contentCollection = new Vector<String>();
				String line = bufferedReader.readLine();
				while (line != null) {
					httpResponse.contentCollection.add(line);
					temp.append(line).append("\r\n");
					line = bufferedReader.readLine();
				}
				bufferedReader.close();
			}

            String ecod = urlConnection.getContentEncoding();
            if (ecod == null) {
                ecod = this.defaultContentEncoding;
            }

            httpResponse.urlString = urlString;
            httpResponse.defaultPort = urlConnection.getURL().getDefaultPort();
            httpResponse.file = urlConnection.getURL().getFile();
            httpResponse.host = urlConnection.getURL().getHost();
            httpResponse.path = urlConnection.getURL().getPath();
            httpResponse.port = urlConnection.getURL().getPort();
            httpResponse.protocol = urlConnection.getURL().getProtocol();
            httpResponse.query = urlConnection.getURL().getQuery();
            httpResponse.ref = urlConnection.getURL().getRef();
            httpResponse.userInfo = urlConnection.getURL().getUserInfo();

			httpResponse.resultByte = responseByte;
            httpResponse.content = temp.toString();
            httpResponse.contentEncoding = ecod;
            httpResponse.code = urlConnection.getResponseCode();
            httpResponse.message = urlConnection.getResponseMessage();
            httpResponse.contentType = urlConnection.getContentType();
            httpResponse.method = urlConnection.getRequestMethod();
            httpResponse.connectTimeout = urlConnection.getConnectTimeout();
            httpResponse.readTimeout = urlConnection.getReadTimeout();

            return httpResponse;
        } catch (IOException e) {
            throw e;
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /**
     * 默认的响应字符集
     */
    public String getDefaultContentEncoding() {
        return this.defaultContentEncoding;
    }

    /**
     * 设置默认的响应字符集
     */
    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.defaultContentEncoding = defaultContentEncoding;
    }
}