package com.kdgcsoft.jt.xzzf.common.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/****
 * @className GuavaUtil
 * @author chris
 * @description 本地缓存工具类
 * @version 1.0
 * @date 2021-03-01 20:42
 */
@Slf4j
@Service
public class GuavaUtil {

    /******
     * 初始定义缓存
     */
    private static LoadingCache<String, String> localCache = CacheBuilder.newBuilder()
            .maximumSize(100000)
            .initialCapacity(25000)
            .concurrencyLevel(8)
            .expireAfterAccess(24, TimeUnit.HOURS)
            .build(new CacheLoader<String, String>() {
                @Override
                public String load(String key) throws Exception {
                    return "";
                }
            });

    /*******
     * 设置缓存信息
     * @param key
     * @param values
     */
    public void set(String key, String values) {
        log.info("设置本地缓存 key:{}， value:{}", key, values);
        localCache.put(key, values);
    }

    /******
     * 清除缓存
     * @param key
     */
    public void delete(String key) {
        log.info("删除本地缓存 key:{}", key);
        localCache.invalidate(key);
    }

    /******
     * 清除全部缓存
     */
    public void deleteAll() {
        log.info("删除本地全部缓存");
        localCache.invalidateAll();
    }

    /*****
     * 获取缓存信息
     * @param key
     * @return
     */
    public String get(String key) {
        log.info("获取本地缓存 key:{}", key);
        try {
            String values = localCache.get(key);
            if (BeanUtils.isNotEmpty(values)) {
                return values;
            } else {
                return null;
            }
        } catch (Exception e) {
            log.info("本地缓存信息获取失败:{}", e);
        }
        return null;
    }
}
