package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/****
 * @className GenerateOrderNoUtil
 * @author chris
 * @description 单号规则工具类
 * @version 1.0
 * @date 2020-03-28 17:24
 */
public class GenerateOrderNoUtil {

    /*******
     * 时间格式
     */
    public static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";

    /*****
     * 装备购置单类别头
     */
    public static final String ORDER_TYPE_ZBGZD = "ZBGZD";

    /*****
     * 装备入库单类别头
     */
    public static final String ORDER_TYPE_ZBRKD = "ZBRKD";

    /*****
     * 非路产建筑物编码
     */
    public static final String ORDER_TYPE_JZWBM = "JZW";

    /*****
     * 架埋设设施编码
     */
    public static final String ORDER_TYPE_JSSS = "JSSS";

    /*****
     * 交通监控设施编码
     */
    public static final String ORDER_TYPE_JTJKSS = "JTJKSS";

    /*****
     * 治超站编码
     */
    public static final String ORDER_TYPE_ZCZ = "ZCZ";

    /*****
     * 穿跨越设施编码
     */
    public static final String ORDER_TYPE_CKYSS = "CKYSS";

    /*****
     * 路线编码
     */
    public static final String ORDER_TYPE_LXBM = "LX";

    /*****
     * 默认订单类别头
     */
    public static final String ORDER_TYPE_DEFAULT = "DEFAULT";

    /**
     * 生成时间戳
     */
    private static String getDateTime() {
        DateFormat sdf = new SimpleDateFormat(GenerateOrderNoUtil.DATE_FORMAT_YYYYMMDD);
        return sdf.format(new Date());
    }

    /*****
     * 生成购置申请单编号
     * @return
     */
    public static String generateGzdOrderNo(String sort) {
        return GenerateOrderNoUtil.generateOrderNo(ORDER_TYPE_ZBGZD, sort);
    }

    /******
     * 获取订单规则
     * @param orderType 订单类型
     * @return
     */
    public static String generateCurOrderNoRules(String orderType) {
        if (StrUtil.isNotEmpty(orderType)) {
            return orderType + getDateTime();
        } else {
            return ORDER_TYPE_DEFAULT + getDateTime();
        }
    }

    /******
     * 生成订单编号
     * @param orderType 订单类型
     * @param sort 序号
     * @return
     */
    public static String generateOrderNo(String orderType, String sort) {
        if (StrUtil.isNotEmpty(orderType)) {
            return orderType + getDateTime() + sort;
        } else {
            return ORDER_TYPE_DEFAULT + getDateTime() + sort;
        }
    }

    public static void main(String[] args) {
        System.out.println("====================>" + GenerateOrderNoUtil.generateCurOrderNoRules(GenerateOrderNoUtil.ORDER_TYPE_ZBGZD));
    }
}
