package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @des Ftp 工具类
 * @author mapp
 * @date 2019-8-2
 */
public class FtpUtilYtsc {

    private static final Logger LOG = LoggerFactory.getLogger(FtpUtilYtsc.class);

    private static String FTP_HOST = PropertyUtil.getProperty("ftpHostHn");
    private static int PORT = Integer.parseInt(PropertyUtil.getProperty("ftpPortHn"));
    private static String USER = PropertyUtil.getProperty("ftpUserHn");
    private static String PWD = PropertyUtil.getProperty("ftpPwdHn");
    private static String BASE_PATH = PropertyUtil.getProperty("ftpPathHn");

    /**
     * 获取FTP客户端
     * @return
     */
    public static Ftp getInstance() {
        Ftp ftp = new Ftp("192.168.61.241", 2121, "root", "kdgc@2019");
        LOG.info("FTP使用被动模式！");
        return ftp;
    }

    /**
     * @des 上传
     * @param path
     * @param fileName
     * @param in
     * @return
     */
    public static boolean upload(String path, String fileName, InputStream in) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            boolean upload = ftp.upload(BASE_PATH + path, fileName, in);
            LOG.info("ftp是否上传成功："+upload);
            return upload;
        } catch (IOException e) {
            LOG.error("FTP附件上传失败！");
            e.printStackTrace();
        }
        return false;
    }



    /**
     * 下载
     * @param basePath
     * @param path
     * @param fileName
     * @param out
     * @return
     */
    public static boolean downLoad(String basePath, String path, String fileName, OutputStream out) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.download(BASE_PATH + path, fileName, out);
            return true;
        } catch (IOException e) {
            LOG.error("FTP附件下载失败！");
            e.printStackTrace();
        }
        return false;
    }

    public static boolean  downLoad(String path, String fileName, OutputStream out) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.download(BASE_PATH , fileName, out);
            return true;
        } catch (IOException e) {
            LOG.error("FTP附件下载失败！");
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 文件是否存在
     * @return
     */
    public static boolean existFile(String pathPath) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.existFile(BASE_PATH + pathPath);
            return true;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}
