package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author mapp
 * @des Ftp 工具类
 * @date 2019-8-2
 */
public class FtpUtil {

    private static final Logger LOG = LoggerFactory.getLogger(FtpUtil.class);

    private static String FTP_HOST = PropertyUtil.getProperty("ftpHost");
    private static int PORT = Integer.parseInt(PropertyUtil.getProperty("ftpPort"));
    private static String USER = PropertyUtil.getProperty("ftpUser");
    private static String PWD = PropertyUtil.getProperty("ftpPwd");
    private static String BASE_PATH = PropertyUtil.getProperty("ftpPath");

    /**
     * 获取FTP客户端
     *
     * @return
     */
    public static Ftp getInstance() {
        Ftp ftp = new Ftp(FTP_HOST, PORT, USER, PWD);
        ftp.setMode(FtpMode.Passive);
        LOG.info("FTP使用被动模式！");
        return ftp;
    }

    /**
     * @param path
     * @param fileName
     * @param in
     * @return
     * @des 上传
     */
    public static boolean upload(String path, String fileName, InputStream in) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            boolean upload = ftp.upload(BASE_PATH + path, fileName, in);
            LOG.info("ftp是否上传成功：" + upload);
            return upload;
        } catch (IOException e) {
            LOG.error("FTP附件上传失败！");
            e.printStackTrace();
        }
        return false;
    }

    /**
     * @param basePath ftp默认根路径
     * @param path
     * @param fileName
     * @param in
     * @return
     * @des 上传
     */
    public static boolean upload(String basePath, String path, String fileName, InputStream in) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(basePath);
            return ftp.upload(basePath + path, fileName, in);
        } catch (IOException e) {
            LOG.error("FTP附件上传失败！");
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 下载
     *
     * @param basePath
     * @param path
     * @param fileName
     * @param out
     * @return
     */
    public static boolean downLoad(String basePath, String path, String fileName, OutputStream out) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.download(basePath + path, fileName, out);
            return true;
        } catch (IOException e) {
            LOG.error("FTP附件下载失败！");
            e.printStackTrace();
        }
        return false;
    }

    public static boolean downLoad(String path, String fileName, OutputStream out) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.download(BASE_PATH + path, fileName, out);
            return true;
        } catch (IOException e) {
            LOG.error("FTP附件下载失败！");
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 文件是否存在
     *
     * @return
     */
    public static boolean existFile(String pathPath) {
        try (Ftp ftp = getInstance()) {
            ftp.cd(BASE_PATH);
            ftp.existFile(BASE_PATH + pathPath);
            return true;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

}
