package com.kdgcsoft.jt.xzzf.common.util;

import com.kdgcsoft.jt.xzzf.common.constant.DBMetaDataConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.Date;

/****
 * @className FillUserInfoUtil
 * @author chris
 * @description 填充用户信息工具类
 * @version 1.0
 * @date 2020-04-30 09:39
 */
public class FillUserInfoUtil {
    /*******
     * 填充创建者信息
     * @param entity
     */
    public static void fillCreater(BaseEntity entity) {
        SysUser curUser = SysUtils.getCurUser();
        entity.setCreater(curUser.getUserId());
        entity.setCreateTime(new Date());
        entity.setUpdater(curUser.getUserId());
        entity.setUpdateTime(new Date());
        entity.setDeleteFlag(DBMetaDataConstant.UNDELETED);
    }

    /*******
     * 填充更新者信息
     * @param entity
     */
    public static void fillUpdater(BaseEntity entity) {
        SysUser curUser = SysUtils.getCurUser();
        entity.setUpdater(curUser.getUserId());
        entity.setUpdateTime(new Date());
    }

    /*******
     * 填充创建信息
     * @param entity 实体类
     * @param curUser 当前登录用户信息
     */
    public static void fillCreateInfo(BaseEntity entity, SysUser curUser) {
        //赋值主键Id
        entity.setId(BeanUtils.isNotEmpty(entity.getId()) ? entity.getId() : IDUtil.uuid());
        //赋值创建时间信息
        entity.setCreateTime(new Date());
        if (BeanUtils.isNotEmpty(curUser)) {
            //赋值创建人信息
            entity.setCreater(curUser.getUserId());
        }
        //填充更新信息
        fillUpdateInfo(entity, curUser);
        //赋值删除标识信息-未删除
        entity.setDeleteFlag(DBMetaDataConstant.UNDELETED);
    }

    /*******
     * 填充更新信息
     * @param entity 实体类
     * @param curUser 当前登录用户信息
     */
    public static void fillUpdateInfo(BaseEntity entity, SysUser curUser) {
        if (BeanUtils.isNotEmpty(curUser)) {
            //赋值修改人信息
            entity.setUpdater(curUser.getUserId());
        }
        //赋值修改时间信息
        entity.setUpdateTime(new Date());
    }


    /*******
     * 填充更新信息
     * @param entity 实体类
     * @param curUser 当前登录用户信息
     */
    public static void fillDeleteInfo(BaseEntity entity, SysUser curUser) {
        //填充更新信息
        fillUpdateInfo(entity, curUser);
        //赋值删除标识信息-已删除
        entity.setDeleteFlag(DBMetaDataConstant.DELETED);
    }
}
