package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;
import org.apache.commons.lang.StringUtils;

/****
 * @className DesensitizeUtil
 * @author chris
 * @description 脱敏工具类
 * @version 1.0
 * @date 2020-03-02 15:09
 */
public class DesensitizeUtil {

    /********
     * 显示开始和截止的明文
     * @param str 待脱敏字符
     * @param startNum 开始节点
     * @param endNum 结束节点
     * @return
     */
    public static String showStartAndEnd(String str, int startNum, int endNum) {
//        System.out.println(str);
        if (StrUtil.isNotEmpty(str)) {
            String s1 = StringUtils.right(str, endNum);
//            System.out.println(s1);
            String s2 = StringUtils.leftPad(s1, StringUtils.length(str), "*");
//            System.out.println(s2);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < startNum; i++) {
                sb.append("*");
            }
            String s3 = StringUtils.removeStart(s2, sb.toString());
//            System.out.println(s3);
            String s4 = StringUtils.left(str, startNum).concat(s3);
//            System.out.println(s4);
            return s4;
        } else {
            return null;
        }
    }

    /*****
     *
     * @param str
     * @param endNum
     * @param totalNum
     * @return
     */
    public static String showEndAndTotal(String str, int endNum, int totalNum) {
        System.out.println(str);
        if (StrUtil.isNotEmpty(str)) {
            String s1 = StringUtils.right(str, endNum);
            System.out.println(s1);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((totalNum - endNum) < 0 ? (endNum - totalNum) : (totalNum - endNum)); i++) {
                sb.append("*");
            }
            String s3 = sb.toString().concat(s1);
            System.out.println(s3);
            return s3;
        } else {
            return null;
        }
    }

    /*******
     * 身份证脱敏
     * @param idCard
     * @return
     */
    public static String idCardDesensitize(String idCard) {
        return showEndAndTotal(idCard, 4, 7);
    }

    /*******
     * 手机号脱敏
     * @param phone
     * @return
     */
    public static String phoneDesensitize(String phone) {
        return showStartAndEnd(phone, 3, 3);
    }

    /*****
     * 字符串截取后6位
     * @param str
     * @return
     */
    public static String subStringBehind6(String str) {
        return str.substring(str.length() - 6);
    }

    public static void main(String[] args) {
        String str = "16655160796";
        subStringBehind6(str);
    }

    /**
     * 保留前几位
     * @Param str, index
     */
    public static String showStartAndTotal(String str, int index) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        String s = StringUtils.left(str, index);
        return StringUtils.rightPad(s, StrUtil.length(str), "*");
    }
}
