package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.date.*;

import java.util.Date;

/****
 * @className DateUtil
 * @author ChrisYolanda
 * @description 日期工具类
 * @version 1.0
 * @date 2020-11-16 14:55
 */
public class DateUtils extends DateUtil {

    /*****
     * 下一年
     * @return
     */
    public static DateTime nextYear() {
        return DateUtils.offsetYear(1);
    }

    /*****
     * 判断两个日期相差的分钟数
     * @param beginDate 起始日期
     * @param endDate 结束日期
     * @return
     */
    public static long betweenMinute(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MINUTE);
    }

    /*****
     * 判断两个日期相差的秒数
     * @param beginDate 起始日期
     * @param endDate 结束日期
     * @return
     */
    public static long betweenSecond(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.SECOND);
    }

    /****
     * 偏移年份
     * @param offset 偏移量，正数为向后偏移，负数为向前偏移
     * @return
     */
    public static DateTime offsetYear(int offset) {
        return offset(new DateTime(), DateField.YEAR, offset);
    }

    /******
     * 比较结果，如果date1 < date2，返回数小于0，date1==date2返回0，date1 > date2 大于0
     * @param date1
     * @param date2
     * @return
     */
    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    /*****
     * 比较结果，如果date1 < date2，返回数小于0，date1==date2返回0，date1 > date2 大于0
     * @param date1
     * @param date2
     * @return
     */
    public static int compareYear(Date date1, Date date2) {
        int year1 = DateUtils.year(date1);
        int year2 = DateUtils.year(date2);
        return CompareUtil.compare(year1, year2);
    }

    /*******
     * 返回法定年龄
     * @param birthDay 出生日期
     * @return
     */
    public static int ageOfNow(Date birthDay) {
        if (BeanUtils.isNotEmpty(birthDay)) {
            return DateUtil.age(birthDay, DateUtil.date());
        } else {
            return 0;
        }
    }

    /******
     * 根据当前时间获取版本号
     * @return
     */
    public static String getVersionByLocalDate() {
        return DateUtils.format(new Date(), DatePattern.PURE_DATETIME_PATTERN);
    }

    /******
     * 根据当前时间获取版本号
     * @param format 返回格式
     * @return
     */
    public static String getVersionByLocalDate(String format) {
        return DateUtils.format(new Date(), format);
    }
}
