package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.JxlsConfig;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.JxlsExcelView;
import org.springframework.web.multipart.MultipartFile;

/****
 * @className CommonUtils
 * @author chris
 * @description 公共工具类
 * @version 1.0
 * @date 2020-06-06 23:05
 */
public class CommonUtils {

    /*****
     * 校验文件类型是否为Excel
     * @param file
     * @return
     */
    public static boolean verifyFileTypeIsExcel(MultipartFile file) {
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        System.out.println("==================fileType:" + fileType);
        if (BeanUtils.isNotEmpty(fileType)) {
            if (JxlsConfig.EXCEL_DEF_SUFFIX_2007.equalsIgnoreCase(fileType) || JxlsConfig.EXCEL_DEF_SUFFIX_2003.equalsIgnoreCase(fileType)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /*****
     * 去除首尾指定字符
     * @param str     字符串
     * @return
     */
    public static String trimFirstAndLastChar(String str) {
        return CommonUtils.trimFirstAndLastChar(str, null);
    }

    /*****
     * 去除首尾指定字符
     * @param str     字符串
     * @param element 指定字符
     * @return
     */
    public static String trimFirstAndLastChar(String str, String element) {
        if (BeanUtils.isNotEmpty(str)) {
            boolean beginIndexFlag = true;
            boolean endIndexFlag = true;
            if (BeanUtils.isEmpty(element)) {
                element = StrUtil.COMMA;
            }
            do {
                if (BeanUtils.isNotEmpty(str)) {
                    int beginIndex = (str.indexOf(element) == 0) ? 1 : 0;
                    int endIndex = (str.lastIndexOf(element) + 1 == str.length()) ? str.lastIndexOf(element) : str.length();
                    str = str.substring(beginIndex, endIndex);
                    beginIndexFlag = (str.indexOf(element) == 0);
                    endIndexFlag = (str.lastIndexOf(element) + 1 == str.length());
                } else {
                    beginIndexFlag = false;
                    endIndexFlag = false;
                }
            } while (beginIndexFlag || endIndexFlag);
        }
        return str;
    }

    /**
     * 去除尾部00字段，便于组织机构的模糊查询
     *
     * @param code
     * @return
     */
    public static String getSearchCode(String code) {
        if (BeanUtils.isNotEmpty(code)){
            String temp = code.replaceAll("(00)+$", "");
            return temp + "%";
        }else{
            return null;
        }
    }
}
