package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.util.StrUtil;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

/**
 * @author chris
 */
public class BeanUtils {
    /**
     * 判断对象或对象数组中每一个对象是否为空: 对象为null，字符序列长度为0，集合类、Map为empty
     *
     * @param obj
     * @return
     */
    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }

        if (obj instanceof CharSequence) {
            return ((CharSequence) obj).length() == 0;
        }

        if (obj instanceof Collection) {
            return ((Collection) obj).isEmpty();
        }

        if (obj instanceof Map) {
            return ((Map) obj).isEmpty();
        }

        if (obj instanceof Object[]) {
            Object[] object = (Object[]) obj;
            if (object.length == 0) {
                return true;
            }
            boolean empty = true;
            for (int i = 0; i < object.length; i++) {
                if (!isEmpty(object[i])) {
                    empty = false;
                    break;
                }
            }
            return empty;
        }

        return false;
    }

    /*****
     * 判断对象是否为非空
     * @param obj
     * @return
     */
    public static boolean isNotEmpty(Object obj) {
        return !isEmpty(obj);
    }

    /*****
     * 字符串转大写
     * @param str
     * @return
     */
    public static String toUpperCase(String str) {
        if (BeanUtils.isNotEmpty(str)) {
            return str.toUpperCase();
        } else {
            return "";
        }
    }

    /*****
     * 字符串转小写
     * @param str
     * @return
     */
    public static String toLowerCase(String str) {
        if (BeanUtils.isNotEmpty(str)) {
            return str.toLowerCase();
        } else {
            return "";
        }
    }

    /**
     * 判断对象中的字段是否全为空
     *
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    public static boolean checkObjFieldIsNull(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return true;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(obj) != null && StrUtil.isNotEmpty(field.get(obj).toString())
                    && !"serialVersionUID".equals(field.getName())) {
                System.out.println("字段:" + field.getName() + "不为空");
                return false;
            }
        }
        return true;
    }
}
