package com.kdgcsoft.jt.xzzf.common.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * 条形码生成工具
 */
public class BarCodeUtil {

    /**
     * 条码
     *
     * @param msg
     * @param path
     */
    public static void getBarCode(String msg, String path) {
        try {
            // 删除旧文件
            FileUtil.del(path);
            File file = new File(path);
            OutputStream ous = new FileOutputStream(file);
            if (StrUtil.isEmpty(msg) || ous == null)
                return;
            //选择条形码类型(好多类型可供选择)
            Code128Bean bean = new Code128Bean();
            //设置长宽
            final double moduleWidth = 0.34;
            final int resolution = 150;
            bean.setModuleWidth(moduleWidth);
            bean.doQuietZone(false);
            String format = "image/png";
            // 输出流
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format,
                    resolution, BufferedImage.TYPE_BYTE_BINARY, false, 0);
            //生成条码
            bean.generateBarcode(canvas, msg);
            canvas.finish();
            ous.flush();
            if (ous != null) {
                ous.close();
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 条码(下面无数字)
     *
     * @param msg
     * @param path
     */
    public static void getBarCodeNoText(String msg, String path) {
        try {
            // 删除旧文件
            FileUtil.del(path);
            File file = new File(path);
            OutputStream ous = new FileOutputStream(file);
            if (StrUtil.isEmpty(msg) || ous == null){
                return;
            }
            Code128Bean bean = new Code128Bean();
            // 设置条形码高度和宽度
//            bean.setBarHeight(10);
            // 设置长宽
            final double moduleWidth = 0.34;
            // 分辨率
            final int resolution = 512;
            bean.setModuleWidth(moduleWidth);
            // 设置两侧是否留白
            bean.doQuietZone(false);
            // 是否显示数字
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
            String format = "image/png";
            // 输出流
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format,
                    resolution, BufferedImage.TYPE_BYTE_BINARY, false, 0);
            //生成条码
            bean.generateBarcode(canvas, msg);
            canvas.finish();
            ous.flush();
            if (ous != null) {
                ous.close();
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}