package com.kdgcsoft.jt.xzzf.common.token;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.constant.CacheKeyConstants;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * token util
 *
 * @author mapp
 */
@Component
public class TokenUtil {

    @Autowired
    RedisUtil redisUtil;

    public String generateTokenId() {
        return IDUtil.uuid();
    }

    /**
     * 刷新token
     * @param simpleToken
     */
    public void touchToken(SimpleToken simpleToken) {
        simpleToken.touch();
        redisUtil.set(CacheKeyConstants.PREFIX_YDZF_TOKEN + simpleToken.getId(), JSONUtil.toJsonStr(simpleToken));
    }

    /**
     * token失效
     * @param simpleToken
     */
    public void expireToken(SimpleToken simpleToken) {
        simpleToken.expire();
        redisUtil.set(CacheKeyConstants.PREFIX_YDZF_TOKEN + simpleToken.getId(), JSONUtil.toJsonStr(simpleToken));
    }

    /**
     * 删除 token
     * @param simpleToken
     */
    public void clearToken(SimpleToken simpleToken) {
        redisUtil.delete(CacheKeyConstants.PREFIX_YDZF_TOKEN + simpleToken.getId());
    }

    /**
     * 获取移动执法有效token
     */
    public List<SimpleToken> getYdzfTokens() {
        List<SimpleToken> simpleTokens = new ArrayList<>();
        Set<String> keys = redisUtil.keys(CacheKeyConstants.PREFIX_YDZF_TOKEN + "*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean(redisUtil.get(key), SimpleToken.class));
            }
        }

        return Collections.unmodifiableList(simpleTokens);
    }

    /**
     * 获取执法公示有效token
     */
    public List<SimpleToken> getZfgsTokens() {
        List<SimpleToken> simpleTokens = new ArrayList<>();
        Set<String> keys = redisUtil.keys(CacheKeyConstants.PREFIX_ZFGS_TOKEN + "*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean(redisUtil.get(key), SimpleToken.class));
            }
        }

        return Collections.unmodifiableList(simpleTokens);
    }

    /**
     * 获取所有有效token
     * @return
     */
    public List<SimpleToken> getTokens() {
        List<SimpleToken> simpleTokens = new ArrayList<>();
        Set<String> keys = redisUtil.keys(CacheKeyConstants.PREFIX_TOKEN + "*");
        if (CollUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                simpleTokens.add(JSONUtil.toBean(redisUtil.get(key), SimpleToken.class));
            }
        }

        return Collections.unmodifiableList(simpleTokens);
    }
}
