package com.kdgcsoft.jt.xzzf.common.token;

import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.entity.JsyxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.zfsj.entity.UserInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * app token
 *
 * @author mapp
 */
@Data
public class SimpleToken implements Serializable {

    private Serializable id;
    private Date startTimestamp;
    private Date lastAccessTime;
    private Long timeOut;
    private boolean expired;
    private SysUser sysUser;
    private UserInfo userInfo;
    private JsyxxVo jsyxxVo;
    private HashMap<Object, Object> attributes;

    public SimpleToken(Serializable id) {
        this.id = id;
        this.timeOut = 3600000L;
        this.startTimestamp = new Date();
        this.lastAccessTime = this.startTimestamp;
        this.attributes = new HashMap<>();
    }

    public SimpleToken(Serializable id, Long timeOut) {
        this(id);
        this.timeOut = timeOut;
    }

    public void touch() {
        this.lastAccessTime = new Date();
    }

    public void expire() {
        this.expired = true;
    }

    public boolean isTimeOut() {
        Date lastAccessTime = getLastAccessTime();
        long expireTimeMillis = System.currentTimeMillis() - getTimeOut();
        Date expireTime = new Date(expireTimeMillis);
        return lastAccessTime.before(expireTime);
    }

    public boolean validate() {
        if (isExpired()) {
            return false;
        } else if (isTimeOut()) {
            return false;
        }
        return true;
    }

    public Serializable getId() {
        return id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getLastAccessTime() {
        return lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Long getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(Long timeOut) {
        this.timeOut = timeOut;
    }

    public boolean isExpired() {
        return expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public Map<Object, Object> getAttributes() {
        return attributes;
    }

    public void setAttributes(HashMap<Object, Object> attributes) {
        this.attributes = attributes;
    }

    public SysUser getSysUser() {
        return sysUser;
    }

    public void setSysUser(SysUser sysUser) {
        this.sysUser = sysUser;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public JsyxxVo getJsyxxVo() {
        return jsyxxVo;
    }

    public void setJsyxxVo(JsyxxVo jsyxxVo) {
        this.jsyxxVo = jsyxxVo;
    }
}
