package com.kdgcsoft.jt.xzzf.common.online;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.constant.CacheKeyConstants;
import com.kdgcsoft.jt.xzzf.common.constant.OnLineConstant;
import com.kdgcsoft.jt.xzzf.common.entity.OnLineUser;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 在线用户登录限制 统一service
 *
 * @author mpp
 */
@Component
public class OnLineUserService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ShiroCasProperties shiroCasProperties;
    private Integer active = 24;

    /**
     * 设置当前用户sessio， tgt值
     *
     * @param sessionId
     * @param st
     */
    public void setSessionTgt(String sessionId, String st) {
        logger.info("setSessionTgt：{}，{}", sessionId, st);
        String tgt = HttpUtil.get(shiroCasProperties.getCasServerUrl() + "getTgt.do?serviceTicketId=" + st);
        redisUtil.setEx(OnLineConstant.PREFIX_SESSION + sessionId + "_" + ShiroKit.getUser().getUserName(), tgt, active, TimeUnit.HOURS);
    }

    /**
     * 获取当前用户sessio， tgt值
     *
     * @param sessionId
     * @return
     */
    public String getSessionTgt(String sessionId) {
        logger.info("getSessionTgt：{}", sessionId);
        return redisUtil.get(OnLineConstant.PREFIX_SESSION + sessionId + "_" + ShiroKit.getUser().getUserName());
    }


    /**
     * 获取当前在线用户
     *
     * @return
     */
    public OnLineUser getCurrentOnlineUser() {
        String casTgt = redisUtil.get(CacheKeyConstants.PREFIX_WEB_TOKEN + ShiroKit.getUser().getUserName());
        if (casTgt != null) {
            return JSONUtil.toBean(casTgt, OnLineUser.class);
        }
        return new OnLineUser();
    }

    /**
     * 检测当前用户的tgt与cas认证中心保存的tgt是否一致，不一致则账号已在其他地方登陆
     *
     * @param sessionId
     * @return
     */
    public boolean checkSessionTgt(String sessionId) {
        String clientTgt = getSessionTgt(sessionId);
        OnLineUser onLineUser = getCurrentOnlineUser();
        return StrUtil.equals(clientTgt, onLineUser.getTgt()) && StrUtil.equals(OnLineConstant.ONLIENE, onLineUser.getStatus());
    }

    /**
     * 获取所有在线用户
     *
     * @return
     */
    public List<OnLineUser> getOnLineUsers() {
        List<OnLineUser> list = new ArrayList<>();
        Set<String> keys = redisUtil.keys(CacheKeyConstants.PREFIX_WEB_TOKEN + "*");
        for (String key : keys) {
            OnLineUser onLineUser = JSONUtil.toBean(redisUtil.get(key), OnLineUser.class);
            if (OnLineConstant.ONLIENE.equals(onLineUser.getStatus())) {
                list.add(onLineUser);
            }
        }
        return list;
    }

    /**
     * 强制用户下线
     *
     * @param userName
     * @return
     */
    public boolean forceLogout(String userName) {
        try {
            String casTgt = redisUtil.get(CacheKeyConstants.PREFIX_WEB_TOKEN + userName);
            if (casTgt != null) {
                OnLineUser onLineUser = JSONUtil.toBean(casTgt, OnLineUser.class);
                onLineUser.setStatus(OnLineConstant.OFFLINE);
                redisUtil.setEx(CacheKeyConstants.PREFIX_WEB_TOKEN + userName, JSONUtil.toJsonStr(onLineUser), active, TimeUnit.HOURS);
                logger.info("强制下线成功！forceLogout：{}", userName);
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("强制下线失败！forceLogout：{}", userName);
        }
        return false;
    }

    /**
     * 从认证中心 退出
     *
     * @param tgt
     * @return
     */
    public boolean forceLogoutCas(String tgt) {
        Map<String, Object> parms = new HashMap<>();
        parms.put("ticketGrantingTicketId", tgt);
        String s = HttpUtil.post(shiroCasProperties.getCasServerUrl() + "onLineUserLogout.do", parms);
        return "success".equals(s);
    }
}
