package com.kdgcsoft.jt.xzzf.common.online;

import com.kdgcsoft.jt.xzzf.common.rest.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 在线用户管理
 *
 * @author mpp
 */
@Controller
@RequestMapping("/onLine")
public class OnLineUserController {

    @Autowired
    private OnLineUserService onLineUserService;

    @RequestMapping("/index")
    public String index() {
        return "onLineUser.html";
    }

    /**
     * 获取在线用户
     *
     * @return
     */
    @RequestMapping("/page")
    @ResponseBody
    public Result onLineUser() {
//        IPage page = new Page();
//        page.setRecords(onLineUserService.getOnLineUsers());
        return Result.success(onLineUserService.getOnLineUsers());
    }

    /**
     * 强制下线
     *
     * @return
     */
    @RequestMapping("/forceLogout")
    @ResponseBody
    public Result forceLagout(String tgt, String userName) {
        onLineUserService.forceLogout(userName);
        return Result.msg("下线成功！");
    }
}
