package com.kdgcsoft.jt.xzzf.common.log.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;

/**
 * 日志操作接口
 *
 * 自定义日志保存需实现此接口，并将实现类交给spring管理
 *
 * @author mapp
 */
public interface LogService {

    /**
     *
     * 插入操作日志
     * @param log
     */
    default void insertOperateLog(OperateLog log) {

    }

    /**
     * 查询操作日志
     *
     *
     * @param log
     * @param currentPage
     * @param size
     */
    default Page<OperateLog> queryOperateLog(OperateLog log, int currentPage, int size) {
        return null;
    }

    /**
     * 插入询登录日志
     *
     *
     * @param log
     *
     */
    default void insertLoginLog(LoginLog log) {

    }

    /**
     *
     * 查询登录日志
     *
     * @param log
     * @param currentPage
     * @param size
     *
     */
    default Page<LoginLog> queryLoginLog(LoginLog log, int currentPage, int size) {
        return null;
    }

    /**
     *
     * 插入异常日志
     * @param log
     */
    default void insertErrorLog(ErrorLog log) {

    }

    /**
     * 查询异常日志
     *
     *
     * @param log
     * @param currentPage
     * @param size
     */
    default Page<ErrorLog> queryErrorLog(ErrorLog log, int currentPage, int size) {
        return null;
    }
}
